/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.rest.component.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.rest.component.BaseUrlBuilder;
import io.rxmicro.annotation.processor.rest.component.HttpMethodMappingBuilder;
import io.rxmicro.annotation.processor.rest.component.PathVariableExtractor;
import io.rxmicro.annotation.processor.rest.model.HttpMethodMapping;
import io.rxmicro.annotation.processor.rest.model.ParentUrl;
import io.rxmicro.common.util.UrlPaths;
import io.rxmicro.rest.method.DELETE;
import io.rxmicro.rest.method.GET;
import io.rxmicro.rest.method.HEAD;
import io.rxmicro.rest.method.HttpMethods;
import io.rxmicro.rest.method.OPTIONS;
import io.rxmicro.rest.method.PATCH;
import io.rxmicro.rest.method.POST;
import io.rxmicro.rest.method.PUT;
import io.rxmicro.rest.model.UrlSegments;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;

@Singleton
public final class HttpMethodMappingBuilderImpl
extends BaseUrlBuilder
implements HttpMethodMappingBuilder {
    @Inject
    private PathVariableExtractor pathVariableExtractor;

    @Override
    public List<HttpMethodMapping> buildList(ParentUrl parentUrl, ExecutableElement element) {
        return Stream.of(Arrays.stream((DELETE[])element.getAnnotationsByType(DELETE.class)).map(a -> this.create(element, a.annotationType(), parentUrl, a.value(), false)), Arrays.stream((GET[])element.getAnnotationsByType(GET.class)).map(a -> this.create(element, a.annotationType(), parentUrl, a.value(), false)), Arrays.stream((HEAD[])element.getAnnotationsByType(HEAD.class)).map(a -> this.create(element, a.annotationType(), parentUrl, a.value(), false)), Arrays.stream((OPTIONS[])element.getAnnotationsByType(OPTIONS.class)).map(a -> this.create(element, a.annotationType(), parentUrl, a.value(), false)), Arrays.stream((POST[])element.getAnnotationsByType(POST.class)).map(a -> this.create(element, a.annotationType(), parentUrl, a.value(), a.httpBody())), Arrays.stream((PATCH[])element.getAnnotationsByType(PATCH.class)).map(a -> this.create(element, a.annotationType(), parentUrl, a.value(), a.httpBody())), Arrays.stream((PUT[])element.getAnnotationsByType(PUT.class)).map(a -> this.create(element, a.annotationType(), parentUrl, a.value(), a.httpBody()))).flatMap(Function.identity()).collect(Collectors.toList());
    }

    @Override
    public HttpMethodMapping buildSingle(ParentUrl parentUrl, ExecutableElement executableElement) {
        List<HttpMethodMapping> mappings = this.buildList(parentUrl, executableElement);
        if (mappings.isEmpty()) {
            throw new InterruptProcessingException((Element)executableElement, "Expected one of the following http method annotations: ?", new Object[]{HttpMethods.HTTP_METHOD_ANNOTATIONS});
        }
        if (mappings.size() > 1) {
            throw new InterruptProcessingException((Element)executableElement, "Expected ONLY one of the following http method annotations: ?", new Object[]{HttpMethods.HTTP_METHOD_ANNOTATIONS});
        }
        return mappings.get(0);
    }

    private HttpMethodMapping create(ExecutableElement executableElement, Class<? extends Annotation> annotationClass, ParentUrl parentUrl, String path, boolean httpBody) {
        HttpMethodMapping.Builder builder = new HttpMethodMapping.Builder().setMethod(annotationClass).setHttpBody(httpBody);
        this.validateNotNull(executableElement, path, "Invalid URL path mapping");
        this.validateThatPathIsTrimmedValue(executableElement, path, "Invalid URL path mapping");
        String normalizeUrlPath = UrlPaths.normalizeUrlPath((String)path);
        if (!path.equals(normalizeUrlPath) && this.getBooleanOption("RX_MICRO_STRICT_MODE", false)) {
            throw new InterruptProcessingException((Element)executableElement, "Invalid request mapping url path: Expected '?', but actual is '?'!", new Object[]{normalizeUrlPath, path});
        }
        String fullPath = parentUrl.getFullUrlPath(path);
        if (path.contains("${")) {
            UrlSegments urlSegments = this.pathVariableExtractor.extractPathSegments(executableElement, fullPath);
            builder.setUrlSegments(urlSegments);
        } else {
            builder.setUri(fullPath);
        }
        if (parentUrl.isHeaderVersionStrategy()) {
            builder.setVersionHeaderValue(parentUrl.getVersionValue());
        }
        return builder.build();
    }
}

