/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.rest.component.impl;

import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.component.impl.BaseProcessorComponent;
import io.rxmicro.annotation.processor.common.model.error.InternalErrorException;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.common.model.type.ModelClass;
import io.rxmicro.annotation.processor.common.util.Annotations;
import io.rxmicro.annotation.processor.common.util.Elements;
import io.rxmicro.annotation.processor.common.util.ProcessingEnvironmentHelper;
import io.rxmicro.annotation.processor.common.util.validators.AnnotationValidators;
import io.rxmicro.annotation.processor.rest.component.ConstraintAnnotationExtractor;
import io.rxmicro.annotation.processor.rest.model.RestModelField;
import io.rxmicro.annotation.processor.rest.model.validator.ModelConstraintAnnotation;
import io.rxmicro.common.RxMicroModule;
import io.rxmicro.validation.base.ConstraintRule;
import java.lang.annotation.ElementType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

@Singleton
public final class ConstraintAnnotationExtractorImpl
extends BaseProcessorComponent
implements ConstraintAnnotationExtractor {
    @Override
    public List<ModelConstraintAnnotation> extract(RestModelField field, ModelClass modelFieldType) {
        ArrayList<ModelConstraintAnnotation> result = new ArrayList<ModelConstraintAnnotation>();
        List annotationMirrors = field.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            TypeElement annotationElement = (TypeElement)Elements.asTypeElement((TypeMirror)annotationMirror.getAnnotationType()).orElseThrow();
            this.getAnnotationMirror(annotationElement, ConstraintRule.class.getName()).ifPresent(customConstraint -> {
                try {
                    this.validateConstraintAnnotation(annotationElement);
                    this.buildModelConstraintAnnotation(field, annotationMirror, (AnnotationMirror)customConstraint, modelFieldType).ifPresent(result::add);
                }
                catch (InterruptProcessingException ex) {
                    this.error(ex);
                }
            });
        }
        return result;
    }

    private void validateConstraintAnnotation(TypeElement annotationElement) {
        if (Optional.ofNullable(ProcessingEnvironmentHelper.getElements().getModuleOf(annotationElement)).map(me -> !me.getQualifiedName().toString().equals(RxMicroModule.RX_MICRO_VALIDATION_MODULE.getName())).orElse(true).booleanValue()) {
            AnnotationValidators.validateCustomAnnotation((TypeElement)annotationElement, Set.of(ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER));
        }
    }

    private Optional<ModelConstraintAnnotation> buildModelConstraintAnnotation(RestModelField field, AnnotationMirror annotationMirror, AnnotationMirror customConstraint, ModelClass modelFieldType) {
        Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = ProcessingEnvironmentHelper.getElements().getElementValuesWithDefaults(annotationMirror);
        if (this.isValidationDisabled(annotationMirror, elementValues)) {
            return Optional.empty();
        }
        TypeElement validatorType = this.getValidatorType(field, annotationMirror, customConstraint, modelFieldType);
        return Optional.of(new ModelConstraintAnnotation(elementValues, annotationMirror, validatorType));
    }

    private Optional<? extends AnnotationMirror> getAnnotationMirror(Element element, String annotationClass) {
        return ProcessingEnvironmentHelper.getElements().getAllAnnotationMirrors(element).stream().filter(a -> ((TypeElement)Elements.asTypeElement((TypeMirror)a.getAnnotationType()).orElseThrow()).getQualifiedName().toString().equals(annotationClass)).findFirst();
    }

    private boolean isValidationDisabled(AnnotationMirror annotationMirror, Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues) {
        try {
            return (Boolean)Annotations.getAnnotationValue(elementValues, (String)"off");
        }
        catch (InternalErrorException ignore) {
            throw new InterruptProcessingException(annotationMirror.getAnnotationType().asElement(), "Add the required annotation parameter: \"boolean off() default false;\".More info is here: https://docs.rxmicro.io/latest/user-guide/validation.html#creating_custom_constraints", new Object[0]);
        }
    }

    private TypeElement getValidatorType(RestModelField field, AnnotationMirror annotationMirror, AnnotationMirror customConstraint, ModelClass modelFieldType) {
        List supportedTypes = (List)Annotations.getAnnotationValue(customConstraint.getElementValues(), (String)"supportedTypes");
        List validatorClasses = (List)Annotations.getAnnotationValue(customConstraint.getElementValues(), (String)"validatorClass");
        if (validatorClasses.size() != supportedTypes.size()) {
            throw new InterruptProcessingException(annotationMirror.getAnnotationType().asElement(), "Expected that supportedTypes.length = validatorClass.length", new Object[0]);
        }
        int index = this.indexOfSupportedClass(field.getFieldClass(), supportedTypes);
        if (index == -1) {
            if (modelFieldType.isIterable()) {
                ModelClass elementModelClass = modelFieldType.asIterable().getElementModelClass();
                index = this.indexOfSupportedClass(field, elementModelClass, annotationMirror, supportedTypes);
                if (index == -1) {
                    throw new InterruptProcessingException(field.getElementAnnotatedBy(annotationMirror), "'?' or '?' types couldn't be validated by @?. Change field type to one of the following: [?]", new Object[]{ProcessingEnvironmentHelper.getTypes().erasure(field.getFieldClass()), elementModelClass.getJavaFullClassName(), ((TypeElement)Elements.asTypeElement((TypeMirror)annotationMirror.getAnnotationType()).orElseThrow()).getQualifiedName(), supportedTypes});
                }
            } else {
                throw new InterruptProcessingException(field.getElementAnnotatedBy(annotationMirror), "'?' type couldn't be validated by @?. Change field type to one of the following: [?]", new Object[]{field.getFieldClass(), ((TypeElement)Elements.asTypeElement((TypeMirror)annotationMirror.getAnnotationType()).orElseThrow()).getQualifiedName(), supportedTypes});
            }
        }
        return (TypeElement)Elements.asTypeElement((TypeMirror)((TypeMirror)((AnnotationValue)validatorClasses.get(index)).getValue())).orElseThrow();
    }

    private int indexOfSupportedClass(RestModelField field, ModelClass elementModelClass, AnnotationMirror annotationMirror, List<?> supportedTypes) {
        if (elementModelClass.isPrimitive()) {
            return this.indexOfSupportedClass(elementModelClass.asPrimitive().getTypeMirror(), supportedTypes);
        }
        if (elementModelClass.isEnum()) {
            return this.indexOfSupportedClass(elementModelClass.asEnum().getTypeMirror(), supportedTypes);
        }
        throw new InterruptProcessingException(field.getElementAnnotatedBy(annotationMirror), "Constraint validation @? can be applied to primitive model classes only. Please remove this annotation", new Object[]{((TypeElement)Elements.asTypeElement((TypeMirror)annotationMirror.getAnnotationType()).orElseThrow()).getQualifiedName()});
    }

    private int indexOfSupportedClass(TypeMirror fieldType, List<?> supportedTypes) {
        for (int i = 0; i < supportedTypes.size(); ++i) {
            TypeMirror supportedType = (TypeMirror)((AnnotationValue)supportedTypes.get(i)).getValue();
            if (!ProcessingEnvironmentHelper.getTypes().isSameType(fieldType, supportedType) && !ProcessingEnvironmentHelper.getTypes().isSubtype(fieldType, supportedType)) continue;
            return i;
        }
        return -1;
    }
}

