/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.rest.component.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.component.IterableContainerElementExtractor;
import io.rxmicro.annotation.processor.common.component.NumberValidators;
import io.rxmicro.annotation.processor.common.component.impl.BaseProcessorComponent;
import io.rxmicro.annotation.processor.common.model.ModelField;
import io.rxmicro.annotation.processor.common.util.Elements;
import io.rxmicro.annotation.processor.rest.component.AnnotationValueValidator;
import io.rxmicro.annotation.processor.rest.model.RestModelField;
import io.rxmicro.annotation.processor.rest.model.validator.ModelConstraintAnnotation;
import io.rxmicro.validation.constraint.Enumeration;
import io.rxmicro.validation.constraint.MaxDouble;
import io.rxmicro.validation.constraint.MaxInt;
import io.rxmicro.validation.constraint.MaxNumber;
import io.rxmicro.validation.constraint.MinDouble;
import io.rxmicro.validation.constraint.MinInt;
import io.rxmicro.validation.constraint.MinNumber;
import io.rxmicro.validation.constraint.Pattern;
import io.rxmicro.validation.constraint.SubEnum;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Element;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

@Singleton
public final class AnnotationValueValidatorImpl
extends BaseProcessorComponent
implements AnnotationValueValidator {
    @Inject
    private NumberValidators numberValidators;
    @Inject
    private Set<IterableContainerElementExtractor> iterableContainerElementExtractors;

    @Override
    public void validate(ModelConstraintAnnotation modelConstraintAnnotation, RestModelField restModelField) {
        if (Enumeration.class.getName().equals(modelConstraintAnnotation.getConstraintAnnotationFullName())) {
            this.validateEnumeration(restModelField);
        } else if (MaxDouble.class.getName().equals(modelConstraintAnnotation.getConstraintAnnotationFullName())) {
            if (Float.class.getName().equals(restModelField.getFieldClass().toString())) {
                double value = restModelField.getAnnotation(MaxDouble.class).value();
                this.numberValidators.validateFloat((ModelField)restModelField, value, MaxDouble.class);
            }
        } else if (MinDouble.class.getName().equals(modelConstraintAnnotation.getConstraintAnnotationFullName())) {
            if (Float.class.getName().equals(restModelField.getFieldClass().toString())) {
                double value = restModelField.getAnnotation(MinDouble.class).value();
                this.numberValidators.validateFloat((ModelField)restModelField, value, MinDouble.class);
            }
        } else if (MaxInt.class.getName().equals(modelConstraintAnnotation.getConstraintAnnotationFullName()) || MinInt.class.getName().equals(modelConstraintAnnotation.getConstraintAnnotationFullName())) {
            this.validateMinMaxInt(modelConstraintAnnotation, restModelField);
        } else if (MaxNumber.class.getName().equals(modelConstraintAnnotation.getConstraintAnnotationFullName()) || MinNumber.class.getName().equals(modelConstraintAnnotation.getConstraintAnnotationFullName())) {
            this.validateMinMaxNumber(modelConstraintAnnotation, restModelField);
        } else if (Pattern.class.getName().equals(modelConstraintAnnotation.getConstraintAnnotationFullName())) {
            this.validateRegExpSyntax(restModelField);
        } else if (SubEnum.class.getName().equals(modelConstraintAnnotation.getConstraintAnnotationFullName())) {
            this.validateEnumConstants(restModelField);
        }
    }

    private void validateMinMaxInt(ModelConstraintAnnotation modelConstraintAnnotation, RestModelField restModelField) {
        Class<MaxInt> annotation;
        long value;
        if (MaxInt.class.getName().equals(modelConstraintAnnotation.getConstraintAnnotationFullName())) {
            value = restModelField.getAnnotation(MaxInt.class).value();
            annotation = MaxInt.class;
        } else {
            value = restModelField.getAnnotation(MinInt.class).value();
            annotation = MinInt.class;
        }
        if (Byte.class.getName().equals(restModelField.getFieldClass().toString())) {
            this.numberValidators.validateByte((ModelField)restModelField, value, annotation);
        } else if (Short.class.getName().equals(restModelField.getFieldClass().toString())) {
            this.numberValidators.validateShort((ModelField)restModelField, value, annotation);
        } else if (Integer.class.getName().equals(restModelField.getFieldClass().toString())) {
            this.numberValidators.validateInteger((ModelField)restModelField, value, annotation);
        }
    }

    private void validateMinMaxNumber(ModelConstraintAnnotation modelConstraintAnnotation, RestModelField restModelField) {
        Class<MaxNumber> annotation;
        String value;
        if (MaxNumber.class.getName().equals(modelConstraintAnnotation.getConstraintAnnotationFullName())) {
            value = restModelField.getAnnotation(MaxNumber.class).value();
            annotation = MaxNumber.class;
        } else {
            value = restModelField.getAnnotation(MinNumber.class).value();
            annotation = MinNumber.class;
        }
        if (Byte.class.getName().equals(restModelField.getFieldClass().toString())) {
            this.numberValidators.validateByte((ModelField)restModelField, value, annotation);
        } else if (Short.class.getName().equals(restModelField.getFieldClass().toString())) {
            this.numberValidators.validateShort((ModelField)restModelField, value, annotation);
        } else if (Integer.class.getName().equals(restModelField.getFieldClass().toString())) {
            this.numberValidators.validateInteger((ModelField)restModelField, value, annotation);
        } else if (Long.class.getName().equals(restModelField.getFieldClass().toString())) {
            this.numberValidators.validateLong((ModelField)restModelField, value, annotation);
        } else if (BigInteger.class.getName().equals(restModelField.getFieldClass().toString())) {
            this.numberValidators.validateBigInteger((ModelField)restModelField, value, annotation);
        } else if (BigDecimal.class.getName().equals(restModelField.getFieldClass().toString())) {
            this.numberValidators.validateBigDecimal((ModelField)restModelField, value, annotation);
        } else if (Float.class.getName().equals(restModelField.getFieldClass().toString())) {
            this.numberValidators.validateFloat((ModelField)restModelField, value, annotation);
        }
    }

    private void validateEnumeration(RestModelField restModelField) {
        Enumeration enumeration = restModelField.getAnnotation(Enumeration.class);
        String[] enums = enumeration.value();
        if (enums.length == 0) {
            this.error(restModelField.getElementAnnotatedBy(Enumeration.class), "Annotation '@?' has invalid parameter: Value couldn't be empty", new Object[]{Enumeration.class.getSimpleName()});
        }
        if (Character.class.getName().equals(restModelField.getFieldClass().toString())) {
            for (String item : enums) {
                if (item.length() == 1) continue;
                this.error(restModelField.getElementAnnotatedBy(Enumeration.class), "Annotation '@?' has invalid parameter: Expected character enum constant, but actual is '?'", new Object[]{Enumeration.class.getSimpleName(), item});
            }
        }
    }

    private void validateRegExpSyntax(RestModelField restModelField) {
        Pattern pattern = restModelField.getAnnotation(Pattern.class);
        try {
            java.util.regex.Pattern.compile(pattern.regexp(), Arrays.stream(pattern.flags()).map(Pattern.Flag::getValue).reduce((f1, f2) -> f1 | f2).orElse(0));
        }
        catch (PatternSyntaxException ex) {
            this.error(restModelField.getElementAnnotatedBy(Pattern.class), "Annotation '@?' has invalid parameter: Invalid regular expression: ?", new Object[]{Pattern.class.getSimpleName(), ex.getMessage()});
        }
    }

    private void validateEnumConstants(RestModelField restModelField) {
        SubEnum subEnum = restModelField.getAnnotation(SubEnum.class);
        List names = Stream.concat(Arrays.stream(subEnum.exclude()), Arrays.stream(subEnum.include())).collect(Collectors.toList());
        Element owner = restModelField.getElementAnnotatedBy(SubEnum.class);
        if (names.isEmpty()) {
            this.error(owner, "Annotation '@?' has invalid parameter: Expected include or exclude values", new Object[]{SubEnum.class.getSimpleName()});
        }
        Set<String> allowedEnumConstants = this.getAllowedEnumConstants(owner, restModelField);
        for (String name : names) {
            if (allowedEnumConstants.contains(name)) continue;
            this.error(owner, "Annotation '@?' has invalid parameter: Value '?' is invalid enum constant. Allowed values: ?", new Object[]{SubEnum.class.getSimpleName(), name, allowedEnumConstants});
        }
        HashSet<String> excludes = new HashSet<String>(Arrays.asList(subEnum.exclude()));
        for (String include : subEnum.include()) {
            if (!excludes.contains(include)) continue;
            this.error(owner, "Annotation '@?' has invalid parameter: Value '?' couldn't be included and excluded at the same time", new Object[]{SubEnum.class.getSimpleName(), include});
        }
    }

    private Set<String> getAllowedEnumConstants(Element owner, RestModelField restModelField) {
        TypeMirror typeMirror = restModelField.getFieldClass();
        return this.getIterableContainerElementExtractor(typeMirror).map(iterableContainerElementExtractor -> Elements.getAllowedEnumConstants((TypeMirror)iterableContainerElementExtractor.getItemType(owner, (DeclaredType)typeMirror))).orElseGet(() -> Elements.getAllowedEnumConstants((TypeMirror)typeMirror));
    }

    private Optional<IterableContainerElementExtractor> getIterableContainerElementExtractor(TypeMirror type) {
        return this.iterableContainerElementExtractors.stream().filter(iterableContainerElementExtractor -> iterableContainerElementExtractor.isSupported(type)).findFirst();
    }
}

