/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.rest.component.impl;

import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.model.ClassHeader;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.common.util.Names;
import io.rxmicro.annotation.processor.rest.component.AnnotationValueConverter;
import io.rxmicro.common.util.Formats;
import io.rxmicro.common.util.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;

@Singleton
public final class AnnotationValueConverterImpl
implements AnnotationValueConverter {
    private final Map<Class<?>, Function<Object, String>> primitiveToStringMap = Map.of(Byte.class, v -> "(byte)" + v, Short.class, v -> "(short)" + v, Long.class, v -> v + "L", Float.class, v -> "(float)" + v, Character.class, v -> Formats.format((String)"'?'", (Object[])new Object[]{v}));

    @Override
    public String convert(Element owner, ClassHeader.Builder classHeaderBuilder, Object value) {
        return this.convert(owner, classHeaderBuilder, value, true);
    }

    private String convert(Element owner, ClassHeader.Builder classHeaderBuilder, Object value, boolean supportArrays) {
        if (this.isPrimitiveParameter(value)) {
            return this.primitiveToString(value);
        }
        if (this.isStringParameter(value)) {
            return Formats.format((String)"\"?\"", (Object[])new Object[]{Strings.escapeString((String)value.toString())});
        }
        if (this.isClassParameter(value)) {
            String fullClassName = value.toString();
            classHeaderBuilder.addImports(new String[]{fullClassName});
            return Names.getSimpleName((String)fullClassName) + ".class";
        }
        if (this.isEnumConstantParameter(value)) {
            VariableElement var = (VariableElement)value;
            String fullClassName = var.asType().toString();
            classHeaderBuilder.addImports(new String[]{fullClassName});
            return Formats.format((String)"?.?", (Object[])new Object[]{Names.getSimpleName((String)fullClassName), var.getSimpleName().toString()});
        }
        if (this.isArrayParameter(value) && supportArrays) {
            return this.arrayToString(owner, classHeaderBuilder, (List)value);
        }
        throw new InterruptProcessingException(owner, "Annotation value: ? (type=?) not supported!", new Object[]{value, value.getClass().getName()});
    }

    private boolean isPrimitiveParameter(Object value) {
        return value instanceof Number || value instanceof Boolean || value instanceof Character;
    }

    private boolean isStringParameter(Object value) {
        return value instanceof String;
    }

    private boolean isClassParameter(Object value) {
        return value instanceof DeclaredType;
    }

    private boolean isEnumConstantParameter(Object value) {
        return value instanceof VariableElement;
    }

    private boolean isArrayParameter(Object value) {
        return value instanceof List;
    }

    private String primitiveToString(Object value) {
        return Optional.ofNullable(this.primitiveToStringMap.get(value.getClass())).orElse(Object::toString).apply(value);
    }

    private String arrayToString(Element owner, ClassHeader.Builder classHeaderBuilder, List<AnnotationValue> list) {
        classHeaderBuilder.addImports(new Class[]{List.class});
        ArrayList<String> values = new ArrayList<String>();
        for (AnnotationValue item : list) {
            values.add(this.convert(owner, classHeaderBuilder, item.getValue(), false));
        }
        return Formats.format((String)"List.of(?)", (Object[])new Object[]{String.join((CharSequence)", ", values)});
    }
}

