/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.rest.component;

import com.google.inject.Inject;
import io.rxmicro.annotation.processor.common.component.impl.AbstractModelFieldBuilder;
import io.rxmicro.annotation.processor.common.model.AnnotatedModelElement;
import io.rxmicro.annotation.processor.common.model.ModelFieldBuilderOptions;
import io.rxmicro.annotation.processor.common.model.ModelFieldType;
import io.rxmicro.annotation.processor.common.model.definition.SupportedTypesProvider;
import io.rxmicro.annotation.processor.common.model.error.InternalErrorException;
import io.rxmicro.annotation.processor.common.model.type.PrimitiveModelClass;
import io.rxmicro.annotation.processor.common.util.Errors;
import io.rxmicro.annotation.processor.common.util.ProcessingEnvironmentHelper;
import io.rxmicro.annotation.processor.rest.component.RestModelFieldBuilder;
import io.rxmicro.annotation.processor.rest.model.RestModelField;
import io.rxmicro.annotation.processor.rest.model.RestObjectModelClass;
import io.rxmicro.annotation.processor.rest.model.RestPrimitiveModelClass;
import io.rxmicro.rest.Header;
import io.rxmicro.rest.Parameter;
import io.rxmicro.rest.PathVariable;
import io.rxmicro.rest.RemoteAddress;
import io.rxmicro.rest.RequestBody;
import io.rxmicro.rest.RequestId;
import io.rxmicro.rest.RequestMethod;
import io.rxmicro.rest.RequestUrlPath;
import io.rxmicro.rest.ResponseBody;
import io.rxmicro.rest.ResponseStatusCode;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

public abstract class AbstractRestModelFieldBuilder
extends AbstractModelFieldBuilder<RestModelField, RestObjectModelClass> {
    @Inject
    private SupportedTypesProvider supportedTypesProvider;
    @Inject
    private RestModelFieldBuilder<Header> headerRestModelFieldBuilder;
    @Inject
    private RestModelFieldBuilder<PathVariable> pathVariableRestModelFieldBuilder;
    @Inject
    private RestModelFieldBuilder<RequestId> requestIdRestModelFieldBuilder;
    @Inject
    private RestModelFieldBuilder<Parameter> parameterRestModelFieldBuilder;

    protected final SupportedTypesProvider getSupportedTypesProvider() {
        return this.supportedTypesProvider;
    }

    protected final RestModelField build(ModelFieldType modelFieldType, VariableElement field, TypeElement typeElement, AbstractModelFieldBuilder.ModelNames modelNames, Set<String> fieldNames, int nestedLevel, ModelFieldBuilderOptions options) {
        String fieldName = field.getSimpleName().toString();
        if (!fieldNames.add(fieldName)) {
            this.error(field, "Detected duplicate of class field name: ?", new Object[]{fieldName});
        }
        AnnotatedModelElement annotated = this.build(typeElement, field);
        this.validateAnnotated(modelFieldType, annotated);
        return this.buildInternal(modelFieldType, annotated).orElseGet(() -> this.buildCustomParameter(modelFieldType, typeElement, modelNames, nestedLevel, annotated, options));
    }

    protected final PrimitiveModelClass createPrimitiveModelClass(TypeMirror type) {
        return new RestPrimitiveModelClass(type);
    }

    protected abstract Optional<RestModelField> buildInternal(ModelFieldType var1, AnnotatedModelElement var2);

    private RestModelField buildCustomParameter(ModelFieldType modelFieldType, TypeElement typeElement, AbstractModelFieldBuilder.ModelNames modelNames, int nestedLevel, AnnotatedModelElement annotated, ModelFieldBuilderOptions options) {
        PathVariable pathVariable = (PathVariable)annotated.getAnnotation(PathVariable.class);
        if (pathVariable != null) {
            RestModelField restModelField = this.pathVariableRestModelFieldBuilder.build(modelFieldType, typeElement, annotated, pathVariable, modelNames.modelNames("path"), nestedLevel);
            return (RestModelField)this.validateAndReturn(options, restModelField, typeElement);
        }
        Header header = (Header)annotated.getAnnotation(Header.class);
        if (header != null) {
            RestModelField restModelField = this.headerRestModelFieldBuilder.build(modelFieldType, typeElement, annotated, header, modelNames.modelNames("headers"), nestedLevel);
            return (RestModelField)this.validateAndReturn(options, restModelField, typeElement);
        }
        RequestId requestId = (RequestId)annotated.getAnnotation(RequestId.class);
        if (requestId != null) {
            RestModelField restModelField = this.requestIdRestModelFieldBuilder.build(modelFieldType, typeElement, annotated, requestId, modelNames.modelNames("headers"), nestedLevel);
            return (RestModelField)this.validateAndReturn(options, restModelField, typeElement);
        }
        Parameter parameter = (Parameter)annotated.getAnnotation(Parameter.class);
        RestModelField restModelField = this.parameterRestModelFieldBuilder.build(modelFieldType, typeElement, annotated, parameter, modelNames.modelNames("params"), nestedLevel);
        return (RestModelField)this.validateAndReturn(options, restModelField, typeElement);
    }

    protected final void validateNoAnnotations(AnnotatedModelElement annotated) {
        if (!annotated.getAllAnnotationMirrors(ProcessingEnvironmentHelper.getElements()).isEmpty()) {
            this.error(annotated.getField(), "Annotations are not allowed for this element", new Object[0]);
        }
    }

    protected abstract Set<Class<? extends Annotation>> supportedRequestAnnotations();

    protected abstract Set<Class<? extends Annotation>> supportedResponseAnnotations();

    private void validateAnnotated(ModelFieldType modelFieldType, AnnotatedModelElement annotated) {
        List<Class<? extends Annotation>> annotationClasses = List.of(Header.class, Parameter.class, PathVariable.class, RequestMethod.class, RequestUrlPath.class, RequestId.class, RemoteAddress.class, RequestBody.class, ResponseBody.class, ResponseStatusCode.class);
        this.validateOnlyOneAnnotationPerElement(annotated, annotationClasses);
        this.validateSupportedAnnotations(annotated, modelFieldType, annotationClasses);
    }

    private void validateOnlyOneAnnotationPerElement(AnnotatedModelElement annotated, List<Class<? extends Annotation>> annotationClasses) {
        if (annotationClasses.stream().map(arg_0 -> ((AnnotatedModelElement)annotated).getAnnotation(arg_0)).filter(Objects::nonNull).count() > 1L) {
            Class annotationClass = annotationClasses.stream().filter(a -> annotated.getAnnotation(a) != null).findFirst().orElseThrow(Errors.IMPOSSIBLE_ERROR_ANNOTATION_NOT_FOUND_SUPPLIER);
            this.error((Element)annotated.getElementAnnotatedBy(annotationClass).orElseThrow(Errors.IMPOSSIBLE_ERROR_ANNOTATION_NOT_FOUND_SUPPLIER), "Use only one annotation per element from the following list: ?", new Object[]{annotationClasses});
        }
    }

    private void validateSupportedAnnotations(AnnotatedModelElement annotated, ModelFieldType modelFieldType, List<Class<? extends Annotation>> annotationClasses) {
        Set<Class<? extends Annotation>> supportedAnnotationClasses = this.getSupportedAnnotations(modelFieldType);
        for (Class<? extends Annotation> annotationClass : annotationClasses) {
            Annotation annotation = annotated.getAnnotation(annotationClass);
            if (annotation == null || supportedAnnotationClasses.contains(annotation.annotationType())) continue;
            this.error((Element)annotated.getElementAnnotatedBy(annotationClass).orElseThrow(Errors.IMPOSSIBLE_ERROR_ANNOTATION_NOT_FOUND_SUPPLIER), "REST annotation '@?' is not allowed here. All supported REST annotations are: ?. Remove the unsupported annotation!", new Object[]{annotation.annotationType().getName(), supportedAnnotationClasses});
        }
    }

    private Set<Class<? extends Annotation>> getSupportedAnnotations(ModelFieldType modelFieldType) {
        if (modelFieldType.isRequest()) {
            return this.supportedRequestAnnotations();
        }
        if (modelFieldType.isResponse()) {
            return this.supportedResponseAnnotations();
        }
        throw new InternalErrorException("Unsupported model type: ?", new Object[]{modelFieldType});
    }
}

