/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.rest.component;

import io.rxmicro.annotation.processor.common.component.impl.BaseProcessorComponent;
import io.rxmicro.annotation.processor.common.model.type.ObjectModelClass;
import io.rxmicro.annotation.processor.rest.model.AbstractModelJsonConverterClassStructure;
import io.rxmicro.annotation.processor.rest.model.HttpMethodMapping;
import io.rxmicro.annotation.processor.rest.model.MappedRestObjectModelClass;
import io.rxmicro.annotation.processor.rest.model.RestObjectModelClass;
import io.rxmicro.common.util.ExCollections;
import io.rxmicro.common.util.ExCollectors;
import io.rxmicro.rest.model.ExchangeFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;

public abstract class AbstractModelJsonConverterBuilder<T extends AbstractModelJsonConverterClassStructure>
extends BaseProcessorComponent {
    protected abstract T newInstance(RestObjectModelClass var1, ExchangeFormat var2, boolean var3);

    public final Set<T> buildFromJson(List<MappedRestObjectModelClass> mappedRestObjectModelClasses, ExchangeFormat exchangeFormat, boolean isRestClientModel) {
        return this.build(mappedRestObjectModelClasses, exchangeFormat, !isRestClientModel, isRestClientModel);
    }

    public final Set<T> buildToJson(List<MappedRestObjectModelClass> mappedRestObjectModelClasses, ExchangeFormat exchangeFormat, boolean isRestClientModel) {
        return this.build(mappedRestObjectModelClasses, exchangeFormat, false, isRestClientModel);
    }

    protected Set<T> build(List<MappedRestObjectModelClass> mappedRestObjectModelClasses, ExchangeFormat exchangeFormat, boolean withHttpBodyOnly, boolean isRestClientModel) {
        HashSet structures = new HashSet();
        for (MappedRestObjectModelClass entry : mappedRestObjectModelClasses) {
            RestObjectModelClass modelClass = entry.getModelClass();
            boolean shouldGenerate = !withHttpBodyOnly || entry.getHttpMethodMappings().stream().anyMatch(HttpMethodMapping::isHttpBody);
            if (!shouldGenerate) continue;
            Set modelClassWithParents = (Set)Stream.concat(Stream.of(modelClass), modelClass.getAllParents().stream()).collect(ExCollectors.toOrderedSet());
            HashSet<ObjectModelClass> modelClasses = new HashSet<ObjectModelClass>(modelClassWithParents);
            for (ObjectModelClass modelClassOrParent : modelClassWithParents) {
                for (ObjectModelClass objectModelClass : modelClassOrParent.getAllChildrenObjectModelClasses()) {
                    modelClasses.add(objectModelClass);
                    modelClasses.addAll(objectModelClass.getAllParents());
                }
            }
            structures.addAll((Collection)modelClasses.stream().filter(mc -> mc.isParamEntriesPresent() || mc.isModelClassReturnedByRestMethod() && mc.isParamEntriesPresentAtThisOrAnyParent()).map(m -> this.newInstance((RestObjectModelClass)((Object)m), exchangeFormat, isRestClientModel)).collect(ExCollectors.toOrderedSet()));
        }
        return ExCollections.unmodifiableOrderedSet(structures);
    }
}

