/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.rest.server.model;

import io.rxmicro.annotation.processor.common.model.EnvironmentContext;
import io.rxmicro.annotation.processor.common.model.ModelFieldType;
import io.rxmicro.annotation.processor.config.DocumentationType;
import io.rxmicro.annotation.processor.rest.model.RestModuleGeneratorConfig;
import io.rxmicro.common.RxMicroModule;
import io.rxmicro.rest.model.ServerExchangeFormatModule;
import io.rxmicro.rest.server.RestServerGeneratorConfig;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public final class RestServerModuleGeneratorConfig
extends RestModuleGeneratorConfig {
    private static final Map<RxMicroModule, DocumentationType> DOCUMENTATION_MAPPING = Map.of(RxMicroModule.RX_MICRO_DOCUMENTATION_ASCIIDOCTOR_MODULE, DocumentationType.ASCII_DOCTOR);
    private final ServerExchangeFormatModule exchangeFormat;
    private final boolean generateRequestValidators;
    private final boolean generateResponseValidators;
    private final Set<DocumentationType> documentationTypes;

    public RestServerModuleGeneratorConfig(EnvironmentContext environmentContext, ServerExchangeFormatModule exchangeFormat, RestServerGeneratorConfig restServerGeneratorConfig) {
        boolean autoValue = environmentContext.isRxMicroModuleEnabled(RxMicroModule.RX_MICRO_VALIDATION_MODULE);
        this.exchangeFormat = exchangeFormat;
        this.generateRequestValidators = this.getOption(restServerGeneratorConfig.generateRequestValidators(), autoValue);
        this.generateResponseValidators = this.getOption(restServerGeneratorConfig.generateResponseValidators(), autoValue);
        this.documentationTypes = environmentContext.getRxMicroModules().stream().flatMap(m -> Optional.ofNullable(DOCUMENTATION_MAPPING.get(m)).stream()).collect(Collectors.toSet());
    }

    public ServerExchangeFormatModule getExchangeFormatModule() {
        return this.exchangeFormat;
    }

    public ModelFieldType getFromHttpDataModelFieldType() {
        return ModelFieldType.REST_SERVER_REQUEST;
    }

    public ModelFieldType getToHttpDataModelFieldType() {
        return ModelFieldType.REST_SERVER_RESPONSE;
    }

    public boolean isGenerateRequestValidators() {
        return this.generateRequestValidators;
    }

    public boolean isGenerateResponseValidators() {
        return this.generateResponseValidators;
    }

    public Set<DocumentationType> getDocumentationTypes() {
        return this.documentationTypes;
    }
}

