/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.rest.server.model;

import io.rxmicro.annotation.processor.common.model.CDIUsageCandidateClassStructure;
import io.rxmicro.annotation.processor.common.model.ClassHeader;
import io.rxmicro.annotation.processor.common.util.GeneratedClassNames;
import io.rxmicro.annotation.processor.common.util.Names;
import io.rxmicro.annotation.processor.rest.model.AbstractSimpleObjectModelClass;
import io.rxmicro.annotation.processor.rest.model.ParentUrl;
import io.rxmicro.annotation.processor.rest.server.model.RestControllerClassStructureStorage;
import io.rxmicro.annotation.processor.rest.server.model.RestControllerMethod;
import io.rxmicro.annotation.processor.rest.server.model.RestServerModuleGeneratorConfig;
import io.rxmicro.annotation.processor.rest.server.model.RestServerSimpleObjectModelClass;
import io.rxmicro.cdi.BeanFactory;
import io.rxmicro.common.util.Formats;
import io.rxmicro.common.util.Requires;
import io.rxmicro.http.HttpHeaders;
import io.rxmicro.rest.model.PathVariableMapping;
import io.rxmicro.rest.model.UrlSegments;
import io.rxmicro.rest.server.detail.component.AbstractRestController;
import io.rxmicro.rest.server.detail.component.ModelReader;
import io.rxmicro.rest.server.detail.component.ModelWriter;
import io.rxmicro.rest.server.detail.component.RestControllerRegistrar;
import io.rxmicro.rest.server.detail.model.HttpRequest;
import io.rxmicro.rest.server.detail.model.HttpResponse;
import io.rxmicro.rest.server.detail.model.Registration;
import io.rxmicro.rest.server.detail.model.mapping.ExactUrlRequestMappingRule;
import io.rxmicro.rest.server.detail.model.mapping.WithUrlPathVariablesRequestMappingRule;
import io.rxmicro.rest.server.feature.EnableCrossOriginResourceSharing;
import io.rxmicro.validation.ConstraintValidator;
import io.rxmicro.validation.detail.ResponseValidators;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.TypeElement;

public final class RestControllerClassStructure
extends CDIUsageCandidateClassStructure {
    private final RestServerModuleGeneratorConfig restServerModuleGeneratorConfig;
    private final ParentUrl parentUrl;
    private final ClassHeader.Builder classHeaderBuilder;
    private final TypeElement ownerClass;
    private final List<RestControllerMethod> methods;
    private final RestControllerClassStructureStorage classStructureStorage;

    public RestControllerClassStructure(RestServerModuleGeneratorConfig restServerModuleGeneratorConfig, ParentUrl parentUrl, ClassHeader.Builder classHeaderBuilder, TypeElement ownerClass, List<RestControllerMethod> methods, RestControllerClassStructureStorage classStructureStorage) {
        this.restServerModuleGeneratorConfig = (RestServerModuleGeneratorConfig)((Object)Requires.require((Object)((Object)restServerModuleGeneratorConfig)));
        this.parentUrl = (ParentUrl)Requires.require((Object)parentUrl);
        this.classHeaderBuilder = (ClassHeader.Builder)Requires.require((Object)classHeaderBuilder);
        this.ownerClass = (TypeElement)Requires.require((Object)ownerClass);
        this.methods = (List)Requires.require(methods);
        this.classStructureStorage = (RestControllerClassStructureStorage)Requires.require((Object)classStructureStorage);
    }

    public ParentUrl getParentUrl() {
        return this.parentUrl;
    }

    public TypeElement getOwnerClass() {
        return this.ownerClass;
    }

    public List<RestControllerMethod> getMethods() {
        return this.methods;
    }

    public String getTargetFullClassName() {
        return Names.getPackageName((TypeElement)this.ownerClass) + ".$$" + this.ownerClass.getSimpleName().toString();
    }

    public String getTemplateName() {
        return "rest/server/$$RestControllerTemplate.javaftl";
    }

    public Map<String, Object> getTemplateVariables() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PREFIX", "$$");
        map.put("USE_CDI", this.isUseCDI());
        map.put("JAVA_CLASS_NAME", this.ownerClass.getSimpleName().toString());
        map.put("JAVA_REQUEST_CLASSES", this.methods.stream().flatMap(m -> m.getFromHttpDataType().stream()).map(RestServerSimpleObjectModelClass::new).collect(Collectors.toSet()));
        map.put("JAVA_RESPONSE_CLASSES", this.methods.stream().flatMap(m -> m.getToHttpDataType().stream()).map(RestServerSimpleObjectModelClass::new).collect(Collectors.toSet()));
        map.put("NOT_FOUND_RESPONSES", this.methods.stream().filter(RestControllerMethod::isNotFoundPossible).map(m -> Map.entry(Formats.format((String)"?NotFoundResponse", (Object[])new Object[]{m.getName().getUniqueJavaName()}), m.getNotFoundMessage())).collect(Collectors.toList()));
        map.put("VOID_RESPONSE_POSSIBLE", this.methods.stream().anyMatch(RestControllerMethod::isVoidReturn));
        Map<String, AbstractSimpleObjectModelClass> requestValidators = this.getRequestValidators();
        Map<String, AbstractSimpleObjectModelClass> responseValidators = this.getResponseValidators();
        map.put("VALIDATORS_MAP", Stream.concat(requestValidators.entrySet().stream(), responseValidators.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (o1, o2) -> o1)));
        map.put("PARENT_CLASS_NAME", AbstractRestController.class.getSimpleName());
        map.put("METHODS", this.methods);
        map.put("PARENT_URL", this.parentUrl.toString());
        map.put("CORS_ENABLED", this.ownerClass.getAnnotation(EnableCrossOriginResourceSharing.class) != null);
        map.put("GENERATE_RESPONSE_VALIDATORS", this.restServerModuleGeneratorConfig.isGenerateResponseValidators());
        return map;
    }

    public ClassHeader getClassHeader() {
        this.classHeaderBuilder.addImports((String[])this.methods.stream().flatMap(m -> m.getFromHttpDataType().stream()).flatMap(t -> this.allImports((TypeElement)t, ModelReader.class, this.classStructureStorage.isRequestValidatorPresent(t.getQualifiedName().toString()))).toArray(String[]::new));
        this.classHeaderBuilder.addImports((String[])this.methods.stream().flatMap(m -> m.getToHttpDataType().stream()).flatMap(t -> this.allImports((TypeElement)t, ModelWriter.class, this.classStructureStorage.isResponseValidatorPresent(t.getQualifiedName().toString()))).toArray(String[]::new));
        this.classHeaderBuilder.addImports(new Class[]{AbstractRestController.class, RestControllerRegistrar.class, Registration.class, HttpRequest.class, HttpResponse.class, PathVariableMapping.class, CompletionStage.class, HttpHeaders.class, WithUrlPathVariablesRequestMappingRule.class, UrlSegments.class, List.class, ExactUrlRequestMappingRule.class}).addStaticImport(ResponseValidators.class, "validateResponse");
        if (this.isUseCDI()) {
            this.classHeaderBuilder.addStaticImport(BeanFactory.class, "getBean");
        }
        return this.classHeaderBuilder.build();
    }

    public String getBeanFullClassName() {
        return this.ownerClass.getQualifiedName().toString();
    }

    private Map<String, AbstractSimpleObjectModelClass> getRequestValidators() {
        HashMap<String, AbstractSimpleObjectModelClass> map = new HashMap<String, AbstractSimpleObjectModelClass>();
        if (this.classStructureStorage.isRequestValidatorsPresent()) {
            map.putAll(this.methods.stream().flatMap(m -> m.getFromHttpDataType().stream()).filter(t -> this.classStructureStorage.isRequestValidatorPresent(t.getQualifiedName().toString())).map(RestServerSimpleObjectModelClass::new).collect(Collectors.toMap(AbstractSimpleObjectModelClass::getJavaFullClassName, Function.identity(), (o1, o2) -> o1)));
        }
        return map;
    }

    private Map<String, AbstractSimpleObjectModelClass> getResponseValidators() {
        HashMap<String, AbstractSimpleObjectModelClass> map = new HashMap<String, AbstractSimpleObjectModelClass>();
        if (this.classStructureStorage.isResponseValidatorsPresent()) {
            map.putAll(this.methods.stream().flatMap(m -> m.getToHttpDataType().stream()).filter(t -> this.classStructureStorage.isResponseValidatorPresent(t.getQualifiedName().toString())).map(RestServerSimpleObjectModelClass::new).collect(Collectors.toMap(AbstractSimpleObjectModelClass::getJavaFullClassName, Function.identity(), (o1, o2) -> o1)));
        }
        return map;
    }

    private Stream<String> allImports(TypeElement typeElement, Class<?> baseTransformerClass, boolean shouldValidatorsBeGenerated) {
        if (shouldValidatorsBeGenerated) {
            return Stream.of(typeElement.getQualifiedName().toString(), GeneratedClassNames.getModelTransformerFullClassName((TypeElement)typeElement, baseTransformerClass), GeneratedClassNames.getModelTransformerFullClassName((TypeElement)typeElement, ConstraintValidator.class));
        }
        return Stream.of(typeElement.getQualifiedName().toString(), GeneratedClassNames.getModelTransformerFullClassName((TypeElement)typeElement, baseTransformerClass));
    }
}

