/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.rest.server.model;

import io.rxmicro.annotation.processor.common.model.ClassHeader;
import io.rxmicro.annotation.processor.common.model.ClassStructure;
import io.rxmicro.annotation.processor.common.model.EnvironmentContext;
import io.rxmicro.annotation.processor.common.util.GeneratedClassNames;
import io.rxmicro.annotation.processor.rest.server.model.CustomExceptionWriterClassStructure;
import io.rxmicro.annotation.processor.rest.server.model.DeclaredStaticResources;
import io.rxmicro.annotation.processor.rest.server.model.HttpHealthCheck;
import io.rxmicro.annotation.processor.rest.server.model.RestControllerClassStructure;
import io.rxmicro.common.RxMicroModule;
import io.rxmicro.common.util.Requires;
import io.rxmicro.config.Configs;
import io.rxmicro.rest.model.UrlSegments;
import io.rxmicro.rest.server.RestServerConfig;
import io.rxmicro.rest.server.detail.component.AbstractRestController;
import io.rxmicro.rest.server.detail.component.BadHttpRequestRestController;
import io.rxmicro.rest.server.detail.component.CrossOriginResourceSharingPreflightRestController;
import io.rxmicro.rest.server.detail.component.CustomExceptionWriters;
import io.rxmicro.rest.server.detail.component.HttpHealthCheckRestController;
import io.rxmicro.rest.server.detail.component.RestControllerAggregator;
import io.rxmicro.rest.server.detail.component.StaticResourceRestController;
import io.rxmicro.rest.server.detail.model.CrossOriginResourceSharingResource;
import io.rxmicro.rest.server.detail.model.HttpHealthCheckRegistration;
import io.rxmicro.rest.server.detail.model.mapping.ExactUrlRequestMappingRule;
import io.rxmicro.rest.server.detail.model.mapping.resource.UrlPathMatchTemplate;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

public final class RestControllerAggregatorClassStructure
extends ClassStructure {
    private final Collection<RestControllerClassStructure> classStructures;
    private final Set<CrossOriginResourceSharingResource> crossOriginResourceSharingResources;
    private final Set<HttpHealthCheck> httpHealthChecks;
    private final DeclaredStaticResources declaredStaticResources;
    private final boolean isRestServerNetty;
    private final Set<CustomExceptionWriterClassStructure> customExceptionModelWriters;

    public RestControllerAggregatorClassStructure(EnvironmentContext environmentContext, Collection<RestControllerClassStructure> classStructures, Set<CrossOriginResourceSharingResource> resources, Set<HttpHealthCheck> httpHealthChecks, DeclaredStaticResources declaredStaticResources, Set<CustomExceptionWriterClassStructure> customExceptionModelWriters) {
        this.crossOriginResourceSharingResources = (Set)Requires.require(resources);
        this.httpHealthChecks = (Set)Requires.require(httpHealthChecks);
        this.declaredStaticResources = declaredStaticResources;
        this.customExceptionModelWriters = (Set)Requires.require(customExceptionModelWriters);
        this.classStructures = new TreeSet<RestControllerClassStructure>(Comparator.comparing(RestControllerClassStructure::getTargetFullClassName));
        this.classStructures.addAll((Collection)Requires.require(classStructures));
        this.isRestServerNetty = environmentContext.isRxMicroModuleEnabled(RxMicroModule.RX_MICRO_REST_SERVER_NETTY_MODULE);
    }

    public String getTargetFullClassName() {
        return GeneratedClassNames.getEntryPointFullClassName((String)RestControllerAggregator.REST_CONTROLLER_AGGREGATOR_IMPL_CLASS_NAME);
    }

    public String getTemplateName() {
        return "rest/server/$$RestControllerAggregatorTemplate.javaftl";
    }

    public Map<String, Object> getTemplateVariables() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List restControllerModels = this.classStructures.stream().map(s -> new RestControllerModel(RestControllerModelType.CUSTOM, s.getTargetFullClassName())).collect(Collectors.toList());
        map.put("CORS_RESOURCES", this.crossOriginResourceSharingResources);
        if (!this.crossOriginResourceSharingResources.isEmpty()) {
            restControllerModels.add(new RestControllerModel(RestControllerModelType.CORS));
        }
        map.put("HTTP_HEALTH_CHECKS", this.httpHealthChecks);
        if (!this.httpHealthChecks.isEmpty()) {
            restControllerModels.add(new RestControllerModel(RestControllerModelType.HEATH_CHECK));
        }
        if (this.isRestServerNetty) {
            restControllerModels.add(new RestControllerModel(RestControllerModelType.BAD_REQUEST_NETTY));
        }
        map.put("IMPL_CLASS_NAME", RestControllerAggregator.REST_CONTROLLER_AGGREGATOR_IMPL_CLASS_NAME);
        map.put("JAVA_REST_CONTROLLER_CLASSES", restControllerModels);
        map.put("ENVIRONMENT_CUSTOMIZER_CLASS", GeneratedClassNames.ENVIRONMENT_CUSTOMIZER_SIMPLE_CLASS_NAME);
        if (this.declaredStaticResources.exist()) {
            restControllerModels.add(new RestControllerModel(RestControllerModelType.STATIC_RESOURCES_STANDARD_CONTROLLER));
            map.put("DECLARED_STATIC_RESOURCES", this.declaredStaticResources);
        }
        map.put("CUSTOM_EXCEPTION_MODEL_WRITERS", this.customExceptionModelWriters);
        return map;
    }

    public ClassHeader getClassHeader() {
        ClassHeader.Builder classHeaderBuilder = ClassHeader.newClassHeaderBuilder((String)"rxmicro").addImports(new Class[]{AbstractRestController.class, RestControllerAggregator.class, List.class});
        if (!this.crossOriginResourceSharingResources.isEmpty()) {
            classHeaderBuilder.addImports(new Class[]{Set.class, CrossOriginResourceSharingPreflightRestController.class, CrossOriginResourceSharingResource.class, UrlSegments.class});
        }
        if (!this.httpHealthChecks.isEmpty()) {
            classHeaderBuilder.addImports(new Class[]{HttpHealthCheckRestController.class, HttpHealthCheckRegistration.class});
        }
        if (this.isRestServerNetty) {
            classHeaderBuilder.addImports(new Class[]{ExactUrlRequestMappingRule.class, BadHttpRequestRestController.class});
        }
        if (this.declaredStaticResources.exist()) {
            this.customizeClassHeaderBuilderForDeclaredStaticResources(classHeaderBuilder);
        }
        if (!this.customExceptionModelWriters.isEmpty()) {
            classHeaderBuilder.addStaticImport(CustomExceptionWriters.class, "registerCustomExceptionWriter").addStaticImport(Configs.class, "getConfig").addImports(new Class[]{RestServerConfig.class});
            this.customExceptionModelWriters.forEach(structure -> {
                classHeaderBuilder.addImports(new String[]{structure.getModelFullClassName()});
                classHeaderBuilder.addImports(new String[]{structure.getTargetFullClassName()});
            });
        }
        return classHeaderBuilder.build();
    }

    private void customizeClassHeaderBuilderForDeclaredStaticResources(ClassHeader.Builder classHeaderBuilder) {
        classHeaderBuilder.addImports(new Class[]{StaticResourceRestController.class, Map.class, List.class});
        for (UrlPathMatchTemplate urlPathMatchTemplate : this.declaredStaticResources.getResourcePathTemplates()) {
            classHeaderBuilder.addImports(new Class[]{urlPathMatchTemplate.getClass()});
        }
        for (Map.Entry entry : this.declaredStaticResources.getCustomTemplateResourceMapping()) {
            classHeaderBuilder.addImports(new Class[]{((UrlPathMatchTemplate)entry.getKey()).getClass()});
        }
        if (!this.declaredStaticResources.getCustomTemplateResourceMapping().isEmpty() || !this.declaredStaticResources.getCustomExactResourceMapping().isEmpty()) {
            classHeaderBuilder.addStaticImport(Map.class, "entry");
        }
    }

    public static enum RestControllerModelType {
        CUSTOM,
        CORS,
        HEATH_CHECK,
        BAD_REQUEST_NETTY,
        STATIC_RESOURCES_STANDARD_CONTROLLER;

    }

    public static final class RestControllerModel {
        private final RestControllerModelType type;
        private final String customClassName;

        public RestControllerModel(RestControllerModelType type, String customClassName) {
            this.type = (RestControllerModelType)((Object)Requires.require((Object)((Object)type)));
            this.customClassName = (String)Requires.require((Object)customClassName);
        }

        public RestControllerModel(RestControllerModelType type) {
            this.type = (RestControllerModelType)((Object)Requires.require((Object)((Object)type)));
            this.customClassName = null;
        }

        public RestControllerModelType getType() {
            return this.type;
        }

        public String getCustomClassName() {
            return this.customClassName;
        }
    }
}

