/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.rest.server.model;

import io.rxmicro.annotation.processor.common.model.type.ObjectModelClass;
import io.rxmicro.annotation.processor.rest.model.RestObjectModelClass;
import io.rxmicro.annotation.processor.rest.model.converter.ReaderType;
import java.util.function.Predicate;

public final class ModelReaderConfigurator {
    private final boolean headersPresents;
    private final boolean internalsPresents;
    private final boolean pathVariablesPresents;
    private final boolean queryParamsPresents;
    private final boolean bodyParamsPresents;

    public ModelReaderConfigurator(RestObjectModelClass modelClass, ReaderType readerType) {
        this.headersPresents = ModelReaderConfigurator.isPresent(modelClass, RestObjectModelClass::isHeadersPresent);
        this.internalsPresents = ModelReaderConfigurator.isPresent(modelClass, RestObjectModelClass::isInternalsPresent);
        this.pathVariablesPresents = ModelReaderConfigurator.isPresent(modelClass, RestObjectModelClass::isPathVariablesPresent);
        if (ModelReaderConfigurator.isPresent(modelClass, ObjectModelClass::isParamEntriesPresent)) {
            this.queryParamsPresents = readerType.isQueryPresent();
            this.bodyParamsPresents = readerType.isHttpBodyPresent();
        } else {
            this.queryParamsPresents = false;
            this.bodyParamsPresents = false;
        }
    }

    private static boolean isPresent(RestObjectModelClass modelClass, Predicate<RestObjectModelClass> predicate) {
        if (predicate.test(modelClass)) {
            return true;
        }
        for (ObjectModelClass parent : modelClass.getAllParents()) {
            if (!predicate.test((RestObjectModelClass)parent)) continue;
            return true;
        }
        return false;
    }

    public boolean isHeadersPresents() {
        return this.headersPresents;
    }

    public boolean isInternalsPresents() {
        return this.internalsPresents;
    }

    public boolean isPathVariablesPresents() {
        return this.pathVariablesPresents;
    }

    public boolean isQueryParamsPresents() {
        return this.queryParamsPresents;
    }

    public boolean isBodyParamsPresents() {
        return this.bodyParamsPresents;
    }

    public String toString() {
        return "ModelReaderConfigurator{headers=" + this.headersPresents + ", internals=" + this.internalsPresents + ", pathVariable=" + this.pathVariablesPresents + ", queryParams=" + this.queryParamsPresents + ", bodyParams=" + this.bodyParamsPresents + "}";
    }
}

