/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.rest.server.model;

import io.rxmicro.annotation.processor.common.model.ClassHeader;
import io.rxmicro.annotation.processor.common.model.WithParentClassStructure;
import io.rxmicro.annotation.processor.common.util.GeneratedClassNames;
import io.rxmicro.annotation.processor.rest.model.RestModelField;
import io.rxmicro.annotation.processor.rest.model.RestObjectModelClass;
import io.rxmicro.annotation.processor.rest.model.converter.ReaderType;
import io.rxmicro.annotation.processor.rest.server.model.AbstractRestControllerModelClassStructure;
import io.rxmicro.annotation.processor.rest.server.model.ModelReaderConfigurator;
import io.rxmicro.common.util.Requires;
import io.rxmicro.exchange.json.detail.JsonExchangeDataFormatConverter;
import io.rxmicro.http.HttpHeaders;
import io.rxmicro.http.QueryParams;
import io.rxmicro.rest.detail.ExchangeDataFormatConverter;
import io.rxmicro.rest.model.ExchangeFormat;
import io.rxmicro.rest.model.HttpModelType;
import io.rxmicro.rest.model.PathVariableMapping;
import io.rxmicro.rest.server.detail.component.ModelReader;
import io.rxmicro.rest.server.detail.model.HttpRequest;
import java.util.Map;

public final class ModelReaderClassStructure
extends AbstractRestControllerModelClassStructure
implements WithParentClassStructure<ModelReaderClassStructure, RestModelField, RestObjectModelClass> {
    private final ReaderType readerType;
    private ModelReaderClassStructure parent;

    public ModelReaderClassStructure(ReaderType readerType, RestObjectModelClass modelClass, ExchangeFormat exchangeFormat) {
        super(modelClass, exchangeFormat);
        this.readerType = (ReaderType)Requires.require((Object)readerType);
    }

    public boolean assignParent(ModelReaderClassStructure parent) {
        if (parent.getModelClass().isHeadersOrPathVariablesOrInternalsPresentAtThisOrAnyParent() || this.readerType.isQueryPresent() && parent.getModelClass().isParamEntriesPresentAtThisOrAnyParent()) {
            this.parent = parent;
            return true;
        }
        return false;
    }

    @Override
    protected Class<?> getBaseTransformerClass() {
        return ModelReader.class;
    }

    @Override
    protected void customize(Map<String, Object> map) {
        map.put("CONFIGURATOR", new ModelReaderConfigurator(this.modelClass, this.readerType));
        if (this.parent != null) {
            map.put("PARENT", this.parent.getTargetSimpleClassName());
            map.put("HAS_PARENT", true);
        } else {
            map.put("HAS_PARENT", false);
        }
    }

    @Override
    protected void addRequiredImports(ClassHeader.Builder classHeaderBuilder) {
        classHeaderBuilder.addImports(new Class[]{ModelReader.class, HttpRequest.class, PathVariableMapping.class, HttpHeaders.class, HttpModelType.class, QueryParams.class, ExchangeDataFormatConverter.class, JsonExchangeDataFormatConverter.class});
        if (this.parent != null) {
            classHeaderBuilder.addImports(new String[]{this.parent.getTargetFullClassName()});
        }
        if (this.isRequiredReflectionSetter()) {
            classHeaderBuilder.addStaticImport(GeneratedClassNames.REFLECTIONS_FULL_CLASS_NAME, "setFieldValue");
        }
    }

    public boolean isRequiredReflectionSetter() {
        return this.modelClass.isInternalsReadReflectionRequired() || this.modelClass.isHeaderReadReflectionRequired() || this.modelClass.isPathVariablesReadReflectionRequired() || this.modelClass.isParamsReadReflectionRequired();
    }
}

