/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.rest.server.model;

import io.rxmicro.common.util.ExCollections;
import io.rxmicro.common.util.ExCollectors;
import io.rxmicro.rest.server.detail.model.mapping.resource.UrlPathMatchTemplate;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;

public final class DeclaredStaticResources {
    private final Collection<UrlPathMatchTemplate> resourcePathTemplates;
    private final Map<UrlPathMatchTemplate, String> customTemplateResourceMapping;
    private final Collection<String> exactResourcePaths;
    private final Map<String, String> customExactResourceMapping;

    public DeclaredStaticResources(Collection<UrlPathMatchTemplate> resourcePathTemplates, Map<UrlPathMatchTemplate, String> customTemplateResourceMapping, Collection<String> exactResourcePaths, Map<String, String> customExactResourceMapping) {
        this.resourcePathTemplates = ExCollections.unmodifiableList(resourcePathTemplates);
        this.customTemplateResourceMapping = ExCollections.unmodifiableOrderedMap(customTemplateResourceMapping);
        this.exactResourcePaths = ExCollections.unmodifiableList(exactResourcePaths);
        this.customExactResourceMapping = ExCollections.unmodifiableOrderedMap(customExactResourceMapping);
    }

    public boolean exist() {
        return !this.resourcePathTemplates.isEmpty() || !this.customTemplateResourceMapping.isEmpty() || !this.exactResourcePaths.isEmpty() || !this.customExactResourceMapping.isEmpty();
    }

    public Set<String> getStaticUrls() {
        return (Set)Stream.of(this.resourcePathTemplates.stream().map(UrlPathMatchTemplate::getUrlTemplate), this.exactResourcePaths.stream()).flatMap(Function.identity()).collect(ExCollectors.toUnmodifiableOrderedSet());
    }

    public Collection<UrlPathMatchTemplate> getResourcePathTemplates() {
        return this.resourcePathTemplates;
    }

    public Set<Map.Entry<UrlPathMatchTemplate, String>> getCustomTemplateResourceMapping() {
        return this.customTemplateResourceMapping.entrySet();
    }

    public Collection<String> getExactResourcePaths() {
        return this.exactResourcePaths;
    }

    public Set<Map.Entry<String, String>> getCustomExactResourceMapping() {
        return this.customExactResourceMapping.entrySet();
    }
}

