/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.rest.server.model;

import io.rxmicro.annotation.processor.common.model.ClassHeader;
import io.rxmicro.annotation.processor.common.model.ClassStructure;
import io.rxmicro.annotation.processor.common.model.error.InternalErrorException;
import io.rxmicro.annotation.processor.common.util.GeneratedClassNames;
import io.rxmicro.annotation.processor.rest.model.RestObjectModelClass;
import io.rxmicro.common.util.Requires;
import io.rxmicro.rest.model.ExchangeFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.lang.model.element.TypeElement;

public abstract class AbstractRestControllerModelClassStructure
extends ClassStructure {
    final RestObjectModelClass modelClass;
    private final ExchangeFormat exchangeFormat;

    AbstractRestControllerModelClassStructure(RestObjectModelClass modelClass, ExchangeFormat exchangeFormat) {
        this.modelClass = (RestObjectModelClass)Requires.require((Object)modelClass);
        this.exchangeFormat = (ExchangeFormat)Requires.require((Object)exchangeFormat);
    }

    public final RestObjectModelClass getModelClass() {
        return this.modelClass;
    }

    public final String getTargetFullClassName() {
        return GeneratedClassNames.getModelTransformerFullClassName((TypeElement)this.modelClass.getModelTypeElement(), this.getBaseTransformerClass());
    }

    public final String getTemplateName() {
        if (this.exchangeFormat == ExchangeFormat.JSON_EXCHANGE_FORMAT) {
            return "rest/server/$$RestJson" + this.getBaseTransformerClass().getSimpleName() + "Template.javaftl";
        }
        throw new InternalErrorException("Not impl yet", new Object[0]);
    }

    public Map<String, Object> getTemplateVariables() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("JAVA_MODEL_CLASS", this.modelClass);
        this.customize(map);
        return map;
    }

    public ClassHeader getClassHeader() {
        ClassHeader.Builder builder = ClassHeader.newClassHeaderBuilder((TypeElement)this.modelClass.getModelTypeElement()).addImports((Collection)this.modelClass.getModelFieldTypes());
        this.addRequiredImports(builder);
        return builder.build();
    }

    public final String getModelFullClassName() {
        return this.modelClass.getJavaFullClassName();
    }

    public final String getModelSimpleClassName() {
        return this.modelClass.getJavaSimpleClassName();
    }

    protected abstract Class<?> getBaseTransformerClass();

    protected void customize(Map<String, Object> map) {
    }

    protected abstract void addRequiredImports(ClassHeader.Builder var1);
}

