/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.rest.server.component.impl.method;

import com.google.inject.Inject;
import io.rxmicro.annotation.processor.common.component.MethodBodyGenerator;
import io.rxmicro.annotation.processor.common.model.ClassHeader;
import io.rxmicro.annotation.processor.common.model.method.MethodBody;
import io.rxmicro.annotation.processor.common.model.method.MethodName;
import io.rxmicro.annotation.processor.common.model.virtual.VirtualTypeMirror;
import io.rxmicro.annotation.processor.common.util.GeneratedClassNames;
import io.rxmicro.annotation.processor.common.util.Names;
import io.rxmicro.annotation.processor.rest.model.RestRequestModel;
import io.rxmicro.annotation.processor.rest.model.RestResponseModel;
import io.rxmicro.annotation.processor.rest.model.StaticHeaders;
import io.rxmicro.annotation.processor.rest.server.component.RestControllerMethodBodyBuilder;
import io.rxmicro.annotation.processor.rest.server.model.RestControllerClassStructureStorage;
import io.rxmicro.annotation.processor.rest.server.model.RestControllerMethodBody;
import io.rxmicro.annotation.processor.rest.server.model.RestServerModuleGeneratorConfig;
import io.rxmicro.rest.server.detail.component.ModelReader;
import io.rxmicro.validation.ConstraintValidator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.lang.model.type.TypeMirror;

public abstract class AbstractParametrizedRestControllerMethodBodyBuilder
implements RestControllerMethodBodyBuilder {
    @Inject
    private MethodBodyGenerator methodBodyGenerator;

    @Override
    public MethodBody build(RestServerModuleGeneratorConfig restServerModuleGeneratorConfig, ClassHeader.Builder classHeaderBuilder, MethodName methodName, int successStatusCode, StaticHeaders staticHeaders, RestRequestModel requestModel, RestResponseModel responseModel, RestControllerClassStructureStorage restControllerClassStructureStorage) {
        this.customizeClassHeaderBuilder(classHeaderBuilder);
        TypeMirror type = requestModel.getRequiredRequestType().asType();
        String requestSimpleClassName = Names.getSimpleName((TypeMirror)type);
        boolean isRequestClassVirtual = type instanceof VirtualTypeMirror;
        List<Object> virtualFields = isRequestClassVirtual ? ((VirtualTypeMirror)type).getVirtualTypeElement().getVirtualFieldElements().stream().map(v -> v.getSimpleName().toString()).collect(Collectors.toList()) : List.of();
        return new RestControllerMethodBody(this.methodBodyGenerator.generate(this.getTemplateName(), Map.of("METHOD_NAME", methodName, "STATUS_CODE", successStatusCode, "RETURN", responseModel, "REQUEST_CLASS", requestSimpleClassName, "IS_REQUEST_CLASS_VIRTUAL", isRequestClassVirtual, "VIRTUAL_FIELDS", virtualFields, "REQUEST_READER", GeneratedClassNames.getModelTransformerInstanceName((TypeMirror)type, ModelReader.class), "REQUEST_VALIDATOR", GeneratedClassNames.getModelTransformerInstanceName((TypeMirror)type, ConstraintValidator.class), "GENERATE_REQUEST_VALIDATORS", restServerModuleGeneratorConfig.isGenerateRequestValidators() && restControllerClassStructureStorage.isRequestValidatorPresent(type.toString()), "STATIC_HEADERS", staticHeaders.getEntries())));
    }

    protected abstract void customizeClassHeaderBuilder(ClassHeader.Builder var1);

    protected abstract String getTemplateName();
}

