/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.rest.server.component.impl;

import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.rest.server.component.UrlPathMatchTemplateClassResolver;
import io.rxmicro.rest.server.detail.model.mapping.resource.AnyOneOrManyUrlPathMatchTemplate;
import io.rxmicro.rest.server.detail.model.mapping.resource.AnySingleUrlPathMatchTemplate;
import io.rxmicro.rest.server.detail.model.mapping.resource.EndsWithAndOneOrMorePathFragmentUrlPathMatchTemplate;
import io.rxmicro.rest.server.detail.model.mapping.resource.EndsWithAndSinglePathFragmentUrlPathMatchTemplate;
import io.rxmicro.rest.server.detail.model.mapping.resource.StartsWithAndOneOrMorePathFragmentUrlPathMatchTemplate;
import io.rxmicro.rest.server.detail.model.mapping.resource.StartsWithAndSinglePathFragmentUrlPathMatchTemplate;
import io.rxmicro.rest.server.detail.model.mapping.resource.UrlPathMatchTemplate;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.element.Element;

@Singleton
public final class UrlPathMatchTemplateClassResolverImpl
implements UrlPathMatchTemplateClassResolver {
    private final Set<String> invalidUrls = Set.of("**", "*/");

    @Override
    public Optional<UrlPathMatchTemplate> getIfExists(Element element, String url) {
        if (this.invalidUrls.contains(url)) {
            throw this.createInterruptProcessingException(element, url);
        }
        if ("/**".equals(url)) {
            return Optional.of(AnyOneOrManyUrlPathMatchTemplate.INSTANCE);
        }
        if ("/*".equals(url)) {
            return Optional.of(AnySingleUrlPathMatchTemplate.INSTANCE);
        }
        Optional<ParseResult> result = this.parseUrl(element, url);
        return result.flatMap(parseResult -> this.interpretParseResult(url, (ParseResult)parseResult));
    }

    private Optional<ParseResult> parseUrl(Element element, String url) {
        AsteriskPosition position = AsteriskPosition.UNDEFINED;
        PathType pathType = PathType.UNDEFINED;
        for (int index = 0; index < url.length(); ++index) {
            char ch = url.charAt(index);
            if (ch != '*') continue;
            if (index == 0) {
                position = AsteriskPosition.END;
                if (url.length() > 1) {
                    pathType = this.getPathType(url.charAt(1));
                    ++index;
                    continue;
                }
                throw this.createInterruptProcessingException(element, url);
            }
            if (index == url.length() - 1) {
                if (position == AsteriskPosition.UNDEFINED) {
                    position = AsteriskPosition.START;
                    pathType = this.getPathType(url.charAt(url.length() - 2));
                    ++index;
                    continue;
                }
                throw this.createInterruptProcessingException(element, url);
            }
            if (index == url.length() - 2) continue;
            throw this.createInterruptProcessingException(element, url);
        }
        return this.convert(position, pathType);
    }

    private PathType getPathType(char ch) {
        if (ch == '*') {
            return PathType.ONE_OR_MANY;
        }
        return PathType.SINGLE;
    }

    private Optional<ParseResult> convert(AsteriskPosition position, PathType pathType) {
        if (position == AsteriskPosition.UNDEFINED) {
            return Optional.empty();
        }
        return Optional.of(new ParseResult(position == AsteriskPosition.START, pathType == PathType.SINGLE));
    }

    private Optional<UrlPathMatchTemplate> interpretParseResult(String url, ParseResult parseResult) {
        if (parseResult.start) {
            if (parseResult.single) {
                return Optional.of(new StartsWithAndSinglePathFragmentUrlPathMatchTemplate(url));
            }
            return Optional.of(new StartsWithAndOneOrMorePathFragmentUrlPathMatchTemplate(url));
        }
        if (parseResult.single) {
            return Optional.of(new EndsWithAndSinglePathFragmentUrlPathMatchTemplate(url));
        }
        return Optional.of(new EndsWithAndOneOrMorePathFragmentUrlPathMatchTemplate(url));
    }

    private InterruptProcessingException createInterruptProcessingException(Element element, String url) {
        return new InterruptProcessingException(element, "Found unsupported resource url template: '?'! Example of supported url templates are: ?", new Object[]{url, List.of("/static/*", "/static*", "/static/**", "/static**", "*.jpg", "*/static/image.jpg", "**.jpg", "**/static/image.jpg", "/*", "/**")});
    }

    private static final class ParseResult {
        private final boolean start;
        private final boolean single;

        private ParseResult(boolean start, boolean single) {
            this.start = start;
            this.single = single;
        }
    }

    private static enum PathType {
        SINGLE,
        ONE_OR_MANY,
        UNDEFINED;

    }

    private static enum AsteriskPosition {
        START,
        END,
        UNDEFINED;

    }
}

