/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.rest.server.component.impl;

import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.component.impl.BaseProcessorComponent;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.rest.model.ParentUrl;
import io.rxmicro.annotation.processor.rest.model.StaticHeaders;
import io.rxmicro.annotation.processor.rest.server.component.ServerCommonOptionBuilder;
import io.rxmicro.common.util.UrlPaths;
import io.rxmicro.rest.AddHeader;
import io.rxmicro.rest.SetHeader;
import java.util.Arrays;
import javax.lang.model.element.Element;

@Singleton
public final class ServerCommonOptionBuilderImpl
extends BaseProcessorComponent
implements ServerCommonOptionBuilder {
    @Override
    public StaticHeaders getStaticHeaders(Element element, ParentUrl parentUrl) {
        StaticHeaders staticHeaders = new StaticHeaders();
        Arrays.stream((AddHeader[])element.getAnnotationsByType(AddHeader.class)).forEach(a -> staticHeaders.add(a.name(), this.getValue(element, parentUrl, a.name(), a.value())));
        Arrays.stream((SetHeader[])element.getAnnotationsByType(SetHeader.class)).forEach(a -> staticHeaders.set(a.name(), this.getValue(element, parentUrl, a.name(), a.value())));
        return staticHeaders;
    }

    private String getValue(Element element, ParentUrl parentUrl, String name, String value) {
        if (value.contains("${")) {
            throw new InterruptProcessingException(element, "Expressions not supported here. Remove redundant expressions!", new Object[0]);
        }
        if ("Location".equalsIgnoreCase(name)) {
            String normalizeUrlPath;
            if (this.getBooleanOption("RX_MICRO_STRICT_MODE", false) && !value.equals(normalizeUrlPath = UrlPaths.normalizeUrlPath((String)value))) {
                throw new InterruptProcessingException(element, "Invalid '?' header value: Expected '?', but actual is '?'!", new Object[]{"Location", normalizeUrlPath, value});
            }
            String parent = parentUrl.getFullUrlPath("");
            if (value.startsWith(parent)) {
                return value;
            }
            return UrlPaths.normalizeUrlPath((String)(parent + "/" + value));
        }
        return value;
    }
}

