/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.rest.server.component.impl;

import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.component.ModuleGeneratorConfigBuilder;
import io.rxmicro.annotation.processor.common.model.EnvironmentContext;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.common.util.Annotations;
import io.rxmicro.annotation.processor.rest.server.model.RestServerModuleGeneratorConfig;
import io.rxmicro.rest.model.ServerExchangeFormatModule;
import io.rxmicro.rest.server.RestServerGeneratorConfig;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.Element;

@Singleton
public final class RestServerModuleGeneratorConfigBuilder
implements ModuleGeneratorConfigBuilder<RestServerModuleGeneratorConfig> {
    public RestServerModuleGeneratorConfig build(EnvironmentContext environmentContext) {
        RestServerGeneratorConfig config = (RestServerGeneratorConfig)Annotations.getPresentOrDefaultAnnotation((AnnotatedConstruct)environmentContext.getCurrentModule(), RestServerGeneratorConfig.class);
        ServerExchangeFormatModule exchangeFormat = this.getExchangeFormat(environmentContext, config);
        return new RestServerModuleGeneratorConfig(environmentContext, exchangeFormat, config);
    }

    private ServerExchangeFormatModule getExchangeFormat(EnvironmentContext environmentContext, RestServerGeneratorConfig config) {
        ServerExchangeFormatModule exchangeFormat = config.exchangeFormat();
        if (exchangeFormat == ServerExchangeFormatModule.AUTO_DETECT) {
            return this.detectExchangeFormatAuto(environmentContext, exchangeFormat);
        }
        return exchangeFormat;
    }

    private ServerExchangeFormatModule detectExchangeFormatAuto(EnvironmentContext environmentContext, ServerExchangeFormatModule exchangeFormat) {
        ServerExchangeFormatModule serverExchangeFormatModule = null;
        for (ServerExchangeFormatModule exchangeFormatModule : exchangeFormat.allExchangeFormatModules()) {
            if (!environmentContext.getRxMicroModules().contains(exchangeFormatModule.getRxMicroModule())) continue;
            if (serverExchangeFormatModule != null) {
                throw new InterruptProcessingException((Element)environmentContext.getCurrentModule(), "Specify exchangeFormat for all REST controllers!", new Object[0]);
            }
            serverExchangeFormatModule = exchangeFormatModule;
        }
        if (serverExchangeFormatModule == null) {
            throw new InterruptProcessingException((Element)environmentContext.getCurrentModule(), "Missing exchange format rxmicro module. Add 'requires rxmicro.rest.server.exchange.json;' to 'module-info.java'", new Object[0]);
        }
        return serverExchangeFormatModule;
    }
}

