/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.rest.server.component.impl;

import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.model.AnnotatedModelElement;
import io.rxmicro.annotation.processor.common.model.ModelFieldBuilderOptions;
import io.rxmicro.annotation.processor.common.model.ModelFieldType;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.common.util.Elements;
import io.rxmicro.annotation.processor.common.util.validators.AnnotationValidators;
import io.rxmicro.annotation.processor.rest.component.AbstractRestModelFieldBuilder;
import io.rxmicro.annotation.processor.rest.model.InternalType;
import io.rxmicro.annotation.processor.rest.model.RestModelField;
import io.rxmicro.annotation.processor.rest.model.RestObjectModelClass;
import io.rxmicro.annotation.processor.rest.server.model.RestServerObjectModelClass;
import io.rxmicro.http.HttpHeaders;
import io.rxmicro.http.HttpVersion;
import io.rxmicro.rest.Header;
import io.rxmicro.rest.Parameter;
import io.rxmicro.rest.PathVariable;
import io.rxmicro.rest.RemoteAddress;
import io.rxmicro.rest.RequestBody;
import io.rxmicro.rest.RequestId;
import io.rxmicro.rest.RequestMethod;
import io.rxmicro.rest.RequestUrlPath;
import io.rxmicro.rest.ResponseBody;
import io.rxmicro.rest.ResponseStatusCode;
import io.rxmicro.rest.server.detail.model.HttpRequest;
import java.lang.annotation.Annotation;
import java.net.SocketAddress;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

@Singleton
public final class RestServerModelFieldBuilderImpl
extends AbstractRestModelFieldBuilder {
    private final Set<Class<?>> requestInternalTypes = Set.of(HttpRequest.class, HttpVersion.class, HttpHeaders.class, SocketAddress.class);
    private final Set<Class<?>> responseInternalTypes = Set.of(HttpVersion.class, HttpHeaders.class);

    protected RestObjectModelClass createObjectModelClass(ModuleElement currentModule, ModelFieldType modelFieldType, TypeMirror type, TypeElement typeElement, int nestedLevel, ModelFieldBuilderOptions options) {
        return new RestServerObjectModelClass(type, typeElement, this.getFieldMap(currentModule, modelFieldType, (TypeElement)Elements.asTypeElement((TypeMirror)type).orElseThrow(), nestedLevel, options), null, true);
    }

    protected Optional<RestModelField> buildInternal(ModelFieldType modelFieldType, AnnotatedModelElement annotated) {
        this.validateInternalTypes(annotated);
        if (HttpRequest.class.getName().equals(annotated.getField().asType().toString())) {
            this.validateInternalByType(modelFieldType, annotated, HttpRequest.class);
            return Optional.of(new RestModelField(annotated, InternalType.HTTP_REQUEST));
        }
        if (HttpVersion.class.getName().equals(annotated.getField().asType().toString())) {
            this.validateInternalByType(modelFieldType, annotated, HttpVersion.class);
            return Optional.of(new RestModelField(annotated, InternalType.HTTP_VERSION));
        }
        if (HttpHeaders.class.getName().equals(annotated.getField().asType().toString())) {
            this.validateInternalByType(modelFieldType, annotated, HttpHeaders.class);
            return Optional.of(new RestModelField(annotated, InternalType.HTTP_HEADERS));
        }
        if (SocketAddress.class.getName().equals(annotated.getField().asType().toString())) {
            if (annotated.getAnnotation(RemoteAddress.class) != null) {
                this.validateInternalByAnnotation(modelFieldType, annotated, RemoteAddress.class);
            } else {
                this.validateInternalByType(modelFieldType, annotated, SocketAddress.class);
            }
            return Optional.of(new RestModelField(annotated, InternalType.REMOTE_ADDRESS));
        }
        return this.buildRequestInternal(modelFieldType, annotated).or(() -> this.buildResponseInternal(modelFieldType, annotated));
    }

    protected Set<Class<? extends Annotation>> supportedRequestAnnotations() {
        return Set.of(Header.class, Parameter.class, PathVariable.class, RequestMethod.class, RequestUrlPath.class, RequestId.class, RemoteAddress.class, RequestBody.class);
    }

    protected Set<Class<? extends Annotation>> supportedResponseAnnotations() {
        return Set.of(Header.class, Parameter.class, ResponseStatusCode.class, ResponseBody.class);
    }

    private Optional<RestModelField> buildRequestInternal(ModelFieldType modelFieldType, AnnotatedModelElement annotated) {
        RequestUrlPath requestUrlPath = (RequestUrlPath)annotated.getAnnotation(RequestUrlPath.class);
        if (requestUrlPath != null) {
            this.validateInternalByAnnotation(modelFieldType, annotated, RequestUrlPath.class);
            AnnotationValidators.validateSupportedTypes((Element)annotated.getField(), (Class)requestUrlPath.annotationType());
            return Optional.of(new RestModelField(annotated, InternalType.REQUEST_URL));
        }
        RequestMethod requestMethod = (RequestMethod)annotated.getAnnotation(RequestMethod.class);
        if (requestMethod != null) {
            this.validateInternalByAnnotation(modelFieldType, annotated, RequestMethod.class);
            AnnotationValidators.validateSupportedTypes((Element)annotated.getField(), (Class)requestMethod.annotationType());
            return Optional.of(new RestModelField(annotated, InternalType.REQUEST_METHOD));
        }
        RemoteAddress remoteAddress = (RemoteAddress)annotated.getAnnotation(RemoteAddress.class);
        if (remoteAddress != null) {
            this.validateInternalByAnnotation(modelFieldType, annotated, RemoteAddress.class);
            AnnotationValidators.validateSupportedTypes((Element)annotated.getField(), (Class)remoteAddress.annotationType());
            return Optional.of(new RestModelField(annotated, InternalType.REMOTE_ADDRESS));
        }
        RequestBody requestBody = (RequestBody)annotated.getAnnotation(RequestBody.class);
        if (requestBody != null) {
            this.validateInternalByAnnotation(modelFieldType, annotated, RequestBody.class);
            AnnotationValidators.validateSupportedTypes((Element)annotated.getField(), (Class)requestBody.annotationType());
            return Optional.of(new RestModelField(annotated, InternalType.REQUEST_BODY));
        }
        return Optional.empty();
    }

    private Optional<RestModelField> buildResponseInternal(ModelFieldType modelFieldType, AnnotatedModelElement annotated) {
        ResponseStatusCode responseStatusCode = (ResponseStatusCode)annotated.getAnnotation(ResponseStatusCode.class);
        if (responseStatusCode != null) {
            this.validateInternalByAnnotation(modelFieldType, annotated, ResponseStatusCode.class);
            AnnotationValidators.validateSupportedTypes((Element)annotated.getField(), (Class)responseStatusCode.annotationType());
            return Optional.of(new RestModelField(annotated, InternalType.RESPONSE_STATUS));
        }
        ResponseBody responseBody = (ResponseBody)annotated.getAnnotation(ResponseBody.class);
        if (responseBody != null) {
            this.validateInternalByAnnotation(modelFieldType, annotated, ResponseBody.class);
            AnnotationValidators.validateSupportedTypes((Element)annotated.getField(), (Class)responseBody.annotationType());
            return Optional.of(new RestModelField(annotated, InternalType.RESPONSE_BODY));
        }
        return Optional.empty();
    }

    private void validateInternalTypes(AnnotatedModelElement annotated) {
        if ("io.netty.handler.codec.http.HttpRequest".equals(annotated.getField().asType().toString())) {
            throw new InterruptProcessingException((Element)annotated.getField(), "Use '?' type instead of 'io.netty.handler.codec.http.HttpRequest' type!", new Object[]{HttpRequest.class.getName()});
        }
        if ("io.netty.handler.codec.http.HttpVersion".equals(annotated.getField().asType().toString())) {
            throw new InterruptProcessingException((Element)annotated.getField(), "Use '?' type instead of 'io.netty.handler.codec.http.HttpVersion' type!", new Object[]{HttpVersion.class.getName()});
        }
        if ("io.netty.handler.codec.http.HttpHeaders".equals(annotated.getField().asType().toString())) {
            throw new InterruptProcessingException((Element)annotated.getField(), "Use '?' type instead of 'io.netty.handler.codec.http.HttpHeaders' type!", new Object[]{HttpHeaders.class.getName()});
        }
    }

    private void validateInternalByType(ModelFieldType modelFieldType, AnnotatedModelElement annotated, Class<?> type) {
        this.validateNoAnnotations(annotated);
        if (!this.requestInternalTypes.contains(type) && modelFieldType == ModelFieldType.REST_SERVER_REQUEST) {
            throw new InterruptProcessingException((Element)annotated.getField(), "'?' type is not supported for request", new Object[]{annotated.getField().asType().toString()});
        }
        if (!this.responseInternalTypes.contains(type) && modelFieldType == ModelFieldType.REST_SERVER_RESPONSE) {
            throw new InterruptProcessingException((Element)annotated.getField(), "'?' type is not supported for response", new Object[]{annotated.getField().asType().toString()});
        }
    }

    private void validateInternalByAnnotation(ModelFieldType modelFieldType, AnnotatedModelElement annotated, Class<? extends Annotation> annotationClass) {
        if (!this.supportedRequestAnnotations().contains(annotationClass) && modelFieldType == ModelFieldType.REST_SERVER_REQUEST) {
            throw new InterruptProcessingException((Element)annotated.getField(), "'?' annotation is not supported for request", new Object[]{annotationClass.getName()});
        }
        if (!this.supportedResponseAnnotations().contains(annotationClass) && modelFieldType == ModelFieldType.REST_SERVER_RESPONSE) {
            throw new InterruptProcessingException((Element)annotated.getField(), "'?' annotation is not supported for response", new Object[]{annotationClass.getName()});
        }
    }
}

