/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.rest.server.component.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.model.SupportedAnnotations;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingBecauseAFewErrorsFoundException;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.common.util.Elements;
import io.rxmicro.annotation.processor.common.util.ProcessingEnvironmentHelper;
import io.rxmicro.annotation.processor.common.util.validators.AnnotationValidators;
import io.rxmicro.annotation.processor.rest.component.HttpMethodMappingBuilder;
import io.rxmicro.annotation.processor.rest.component.RestRequestModelBuilder;
import io.rxmicro.annotation.processor.rest.component.RestResponseModelBuilder;
import io.rxmicro.annotation.processor.rest.component.impl.AbstractRestMethodSignatureBuilder;
import io.rxmicro.annotation.processor.rest.model.ParentUrl;
import io.rxmicro.annotation.processor.rest.model.RestRequestModel;
import io.rxmicro.annotation.processor.rest.server.component.RestControllerMethodSignatureBuilder;
import io.rxmicro.annotation.processor.rest.server.model.RestControllerMethodSignature;
import io.rxmicro.common.util.ExCollections;
import io.rxmicro.documentation.Description;
import io.rxmicro.documentation.IncludeDescription;
import io.rxmicro.documentation.ModelExceptionErrorResponse;
import io.rxmicro.documentation.ResourceDefinition;
import io.rxmicro.documentation.SimpleErrorResponse;
import io.rxmicro.documentation.Title;
import io.rxmicro.rest.AddHeader;
import io.rxmicro.rest.HeaderMappingStrategy;
import io.rxmicro.rest.ParameterMappingStrategy;
import io.rxmicro.rest.SetHeader;
import io.rxmicro.rest.method.DELETE;
import io.rxmicro.rest.method.GET;
import io.rxmicro.rest.method.HEAD;
import io.rxmicro.rest.method.OPTIONS;
import io.rxmicro.rest.method.PATCH;
import io.rxmicro.rest.method.POST;
import io.rxmicro.rest.method.PUT;
import io.rxmicro.rest.server.NotFoundMessage;
import io.rxmicro.rest.server.SetStatusCode;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.TypeElement;

@Singleton
public final class RestControllerMethodSignatureBuilderImpl
extends AbstractRestMethodSignatureBuilder
implements RestControllerMethodSignatureBuilder {
    @Inject
    private HttpMethodMappingBuilder httpMethodMappingBuilder;
    @Inject
    private RestRequestModelBuilder restRequestModelBuilder;
    @Inject
    private RestResponseModelBuilder restResponseModelBuilder;

    @Override
    public List<RestControllerMethodSignature> build(ModuleElement restControllerModule, TypeElement restControllerClass, ParentUrl parentUrl) {
        List<RestControllerMethodSignature> methods = Elements.allMethods((TypeElement)restControllerClass, el -> el.getAnnotationMirrors().stream().anyMatch(a -> this.getSupportedAnnotations().isAnnotationSupported(a.getAnnotationType()))).stream().map(method -> this.getRestControllerMethodSignature(restControllerModule, parentUrl, (ExecutableElement)method)).collect(Collectors.toList());
        if (!ProcessingEnvironmentHelper.doesContainCompilationErrors()) {
            return methods;
        }
        throw new InterruptProcessingBecauseAFewErrorsFoundException();
    }

    private RestControllerMethodSignature getRestControllerMethodSignature(ModuleElement restControllerModule, ParentUrl parentUrl, ExecutableElement method) {
        try {
            this.validateMethodName(method);
            List<? extends AnnotationMirror> annotations = method.getAnnotationMirrors();
            AnnotationValidators.validateRedundantAnnotationsPerElement((Element)method, annotations, (SupportedAnnotations)this.getSupportedAnnotations(), (String)"Rest controller method");
            this.validateAnnotatedClassMethodModifiers(method, annotations.stream().filter(a -> this.getHttpMethodAnnotations().isAnnotationSupported(a.getAnnotationType())).collect(Collectors.toList()));
            RestRequestModel requestModel = this.restRequestModelBuilder.build(restControllerModule, method, true);
            if (!requestModel.isVirtual()) {
                AnnotationValidators.validateNoAnnotationPerElement((Element)method, HeaderMappingStrategy.class);
                AnnotationValidators.validateNoAnnotationPerElement((Element)method, ParameterMappingStrategy.class);
            }
            return new RestControllerMethodSignature(parentUrl, method, requestModel, this.restResponseModelBuilder.build(restControllerModule, method, false), this.httpMethodMappingBuilder.buildList(parentUrl, method));
        }
        catch (InterruptProcessingException exception) {
            this.error(exception);
            return null;
        }
    }

    private void validateMethodName(ExecutableElement method) {
        if ("postConstruct".equals(method.getSimpleName().toString())) {
            throw new InterruptProcessingException((Element)method, "Invalid rest controller method name. The name '?' is reserved for CDI module. Rename the method!", new Object[]{"postConstruct"});
        }
    }

    protected Set<Class<? extends Annotation>> getSupportedAnnotationsPerMethod() {
        return ExCollections.unmodifiableOrderedSet(Arrays.asList(GET.class, POST.class, PUT.class, DELETE.class, PATCH.class, OPTIONS.class, HEAD.class, HeaderMappingStrategy.class, ParameterMappingStrategy.class, SetStatusCode.class, NotFoundMessage.class, IncludeDescription.class, ModelExceptionErrorResponse.class, SimpleErrorResponse.class, Title.class, Description.class, ResourceDefinition.class, SetHeader.class, AddHeader.class));
    }
}

