/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.rest.server.component.impl;

import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.model.EnvironmentContext;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.rest.server.component.HttpHealthCheckBuilder;
import io.rxmicro.annotation.processor.rest.server.model.HttpHealthCheck;
import io.rxmicro.annotation.processor.rest.server.model.RestControllerClassStructure;
import io.rxmicro.monitoring.healthcheck.EnableHttpHealthCheck;
import java.util.Set;
import java.util.TreeSet;
import javax.lang.model.element.Element;

@Singleton
public final class HttpHealthCheckBuilderImpl
implements HttpHealthCheckBuilder {
    @Override
    public Set<HttpHealthCheck> build(EnvironmentContext environmentContext, Set<RestControllerClassStructure> restControllerClassStructures) {
        TreeSet<HttpHealthCheck> set = new TreeSet<HttpHealthCheck>();
        EnableHttpHealthCheck enableHttpHealthCheckOnModule = environmentContext.getCurrentModule().getAnnotation(EnableHttpHealthCheck.class);
        if (enableHttpHealthCheckOnModule != null) {
            set.add(new HttpHealthCheck(enableHttpHealthCheckOnModule.method(), "/http-health-check"));
        }
        for (RestControllerClassStructure restControllerClassStructure : restControllerClassStructures) {
            EnableHttpHealthCheck enableHttpHealthCheck = restControllerClassStructure.getOwnerClass().getAnnotation(EnableHttpHealthCheck.class);
            if (enableHttpHealthCheck == null) continue;
            if (!set.isEmpty()) {
                throw new InterruptProcessingException((Element)restControllerClassStructure.getOwnerClass(), "The RxMicro framework supports only one @? annotation per project", new Object[]{EnableHttpHealthCheck.class.getName()});
            }
            set.add(new HttpHealthCheck(enableHttpHealthCheck.method(), "/http-health-check"));
        }
        return set;
    }
}

