/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.rest.server.component.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.model.EnvironmentContext;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.rest.component.BaseUrlBuilder;
import io.rxmicro.annotation.processor.rest.server.component.DeclaredStaticResourcesResolver;
import io.rxmicro.annotation.processor.rest.server.component.UrlPathMatchTemplateClassResolver;
import io.rxmicro.annotation.processor.rest.server.model.DeclaredStaticResources;
import io.rxmicro.common.util.Formats;
import io.rxmicro.common.util.Strings;
import io.rxmicro.common.util.UrlPaths;
import io.rxmicro.rest.server.StaticResources;
import io.rxmicro.rest.server.detail.model.mapping.resource.UrlPathMatchTemplate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

@Singleton
public final class DeclaredStaticResourcesResolverImpl
extends BaseUrlBuilder
implements DeclaredStaticResourcesResolver {
    @Inject
    private UrlPathMatchTemplateClassResolver urlPathMatchTemplateClassResolver;

    @Override
    public DeclaredStaticResources resolve(EnvironmentContext environmentContext, Collection<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        DeclaredStaticResourcesHolder holder = new DeclaredStaticResourcesHolder();
        HashSet<String> processedTypes = new HashSet<String>();
        for (TypeElement typeElement : annotations) {
            for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                TypeElement restControllerClass;
                if (!(element instanceof TypeElement) || !environmentContext.isRxMicroClassShouldBeProcessed(restControllerClass = (TypeElement)element) || !processedTypes.add(restControllerClass.asType().toString())) continue;
                this.addStaticResources(restControllerClass, holder);
            }
        }
        this.addStaticResources(environmentContext.getCurrentModule(), holder);
        return this.buildDeclaredStaticResources(holder);
    }

    private void addStaticResources(Element owner, DeclaredStaticResourcesHolder holder) {
        for (StaticResources staticResources : (StaticResources[])owner.getAnnotationsByType(StaticResources.class)) {
            this.validateStaticResourcesParameters(owner, staticResources);
            Map.Entry<List<String>, List<String>> resources = this.getStaticResources(owner, staticResources);
            this.addStaticResource(owner, resources, holder);
        }
    }

    private void validateStaticResourcesParameters(Element owner, StaticResources staticResources) {
        if (staticResources.value().length == 0 && staticResources.urls().length == 0) {
            throw new InterruptProcessingException(owner, "'@?' annotation must contain not empty array of static resources! Add missing resources using 'value' or 'urls' annotation parameters or remove this annotation!", new Object[]{StaticResources.class.getSimpleName()});
        }
        if (staticResources.value().length != 0 && staticResources.urls().length != 0) {
            throw new InterruptProcessingException(owner, "'value' and 'urls' annotation parameters of '@?' annotation are aliases and can't be used together! Remove 'value' or 'urls' annotation parameter!", new Object[]{StaticResources.class.getSimpleName()});
        }
        int filePathsLength = staticResources.filePaths().length;
        if (filePathsLength != 0 && filePathsLength != staticResources.value().length && filePathsLength != staticResources.urls().length) {
            throw new InterruptProcessingException(owner, "Invalid parameters for '@?' annotation: filePaths().length must be equal to urls().length or value().length!", new Object[]{StaticResources.class.getSimpleName()});
        }
    }

    private Map.Entry<List<String>, List<String>> getStaticResources(Element owner, StaticResources staticResources) {
        int filePathsLength = staticResources.filePaths().length;
        if (staticResources.value().length != 0) {
            List<String> urls = this.normalize(owner, staticResources.value(), "value");
            if (filePathsLength != 0) {
                return Map.entry(urls, List.of(staticResources.filePaths()));
            }
            return Map.entry(urls, List.of());
        }
        List<String> urls = this.normalize(owner, staticResources.urls(), "url");
        if (filePathsLength != 0) {
            return Map.entry(urls, List.of(staticResources.filePaths()));
        }
        return Map.entry(urls, List.of());
    }

    private List<String> normalize(Element owner, String[] values, String name) {
        return Arrays.stream(values).map(value -> {
            this.validateNotNull(owner, (String)value, Formats.format((String)"? can't be null!", (Object[])new Object[]{name}));
            this.validateNotEmpty(owner, (String)value, Formats.format((String)"? can't be empty string!", (Object[])new Object[]{name}));
            this.validateThatPathIsTrimmedValue(owner, (String)value, Formats.format((String)"? must not contain space characters!", (Object[])new Object[]{name}));
            String normalizeUrlPath = Strings.startsWith((String)value, (char)'*') ? UrlPaths.normalizeUrlPath((String)value).substring(1) : UrlPaths.normalizeUrlPath((String)value);
            if (!normalizeUrlPath.equals(value) && this.getBooleanOption("RX_MICRO_STRICT_MODE", false)) {
                throw new InterruptProcessingException(owner, "Invalid static resource ?: Expected '?', but actual is '?'!", new Object[]{name, normalizeUrlPath, value});
            }
            return normalizeUrlPath;
        }).collect(Collectors.toList());
    }

    private void addStaticResource(Element owner, Map.Entry<List<String>, List<String>> resources, DeclaredStaticResourcesHolder holder) {
        for (int i = 0; i < resources.getKey().size(); ++i) {
            String url = resources.getKey().get(i);
            Optional<UrlPathMatchTemplate> urlPathMatchTemplate = this.urlPathMatchTemplateClassResolver.getIfExists(owner, url);
            if (resources.getValue().isEmpty()) {
                if (urlPathMatchTemplate.isPresent()) {
                    this.validateThatUrlIsUnique(owner, holder, urlPathMatchTemplate.get());
                    holder.resourcePathTemplates.add(urlPathMatchTemplate.get());
                    continue;
                }
                this.validateThatUrlIsUnique(owner, holder, url);
                holder.exactResourcePaths.add(url);
                continue;
            }
            String filePath = resources.getValue().get(i);
            if (urlPathMatchTemplate.isPresent()) {
                this.validateThatUrlIsUnique(owner, holder, urlPathMatchTemplate.get());
                holder.customTemplateResourceMapping.put(urlPathMatchTemplate.get(), filePath);
                continue;
            }
            this.validateThatUrlIsUnique(owner, holder, url);
            holder.customExactResourceMapping.put(url, filePath);
        }
    }

    private void validateThatUrlIsUnique(Element owner, DeclaredStaticResourcesHolder holder, String url) {
        boolean throwError = false;
        if (holder.exactResourcePaths.contains(url)) {
            throwError = true;
        } else if (holder.customExactResourceMapping.containsKey(url)) {
            throwError = true;
        }
        if (throwError) {
            throw new InterruptProcessingException(owner, "The '?' static resource is not unique! Remove duplicate of the static resource definition!", new Object[]{url});
        }
    }

    private void validateThatUrlIsUnique(Element owner, DeclaredStaticResourcesHolder holder, UrlPathMatchTemplate urlPathMatchTemplate) {
        boolean throwError = false;
        if (holder.resourcePathTemplates.contains(urlPathMatchTemplate)) {
            throwError = true;
        } else if (holder.customTemplateResourceMapping.containsKey(urlPathMatchTemplate)) {
            throwError = true;
        }
        if (throwError) {
            throw new InterruptProcessingException(owner, "The '?' static resource is not unique! Remove duplicate of the static resource definition!", new Object[]{urlPathMatchTemplate.getUrlTemplate()});
        }
    }

    private DeclaredStaticResources buildDeclaredStaticResources(DeclaredStaticResourcesHolder holder) {
        ArrayList<UrlPathMatchTemplate> resourcePathTemplates = new ArrayList<UrlPathMatchTemplate>(holder.resourcePathTemplates);
        resourcePathTemplates.addAll(holder.customTemplateResourceMapping.keySet());
        resourcePathTemplates.sort(UrlPathMatchTemplate::compareTo);
        ArrayList<String> exactResourcePaths = new ArrayList<String>(holder.exactResourcePaths);
        exactResourcePaths.addAll(holder.customExactResourceMapping.keySet());
        return new DeclaredStaticResources(resourcePathTemplates, holder.customTemplateResourceMapping, exactResourcePaths, holder.customExactResourceMapping);
    }

    private static final class DeclaredStaticResourcesHolder {
        private final Set<UrlPathMatchTemplate> resourcePathTemplates = new LinkedHashSet<UrlPathMatchTemplate>();
        private final Map<UrlPathMatchTemplate, String> customTemplateResourceMapping = new LinkedHashMap<UrlPathMatchTemplate, String>();
        private final Set<String> exactResourcePaths = new LinkedHashSet<String>();
        private final Map<String, String> customExactResourceMapping = new LinkedHashMap<String, String>();

        private DeclaredStaticResourcesHolder() {
        }
    }
}

