/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.rest.server.component.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.component.ModelFieldBuilder;
import io.rxmicro.annotation.processor.common.model.EnvironmentContext;
import io.rxmicro.annotation.processor.common.model.ModelFieldBuilderOptions;
import io.rxmicro.annotation.processor.common.model.ModelFieldType;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.common.util.Elements;
import io.rxmicro.annotation.processor.rest.model.MappedRestObjectModelClass;
import io.rxmicro.annotation.processor.rest.model.RestModelField;
import io.rxmicro.annotation.processor.rest.model.RestObjectModelClass;
import io.rxmicro.annotation.processor.rest.server.component.CustomExceptionMappedRestObjectModelClassBuilder;
import io.rxmicro.common.local.DeniedPackages;
import io.rxmicro.http.error.HttpErrorException;
import io.rxmicro.rest.ResponseStatusCode;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;

@Singleton
public final class CustomExceptionMappedRestObjectModelClassBuilderImpl
implements CustomExceptionMappedRestObjectModelClassBuilder {
    @Inject
    private ModelFieldBuilder<RestModelField, RestObjectModelClass> modelFieldBuilder;

    @Override
    public List<MappedRestObjectModelClass> build(EnvironmentContext environmentContext) {
        Set packageElements = Stream.of(environmentContext.getCurrentModule()).flatMap(me -> me.getEnclosedElements().stream().map(e -> (PackageElement)e)).filter(pe -> !DeniedPackages.isDeniedPackage((String)pe.getQualifiedName().toString())).collect(Collectors.toSet());
        return packageElements.stream().flatMap(pe -> pe.getEnclosedElements().stream().filter(e -> e instanceof TypeElement).map(e -> (TypeElement)e)).filter(arg_0 -> ((EnvironmentContext)environmentContext).isRxMicroClassShouldBeProcessed(arg_0)).filter(this::isSubClassOfHttpErrorException).map(te -> this.getModelClass(environmentContext, (TypeElement)te)).filter(this::isCustomExceptionModelClass).map(mc -> new MappedRestObjectModelClass(mc, List.of())).collect(Collectors.toList());
    }

    private boolean isSubClassOfHttpErrorException(TypeElement type) {
        return type.getKind() == ElementKind.CLASS && Elements.findSuperType((TypeElement)type, HttpErrorException.class).isPresent();
    }

    private boolean isCustomExceptionModelClass(RestObjectModelClass restObjectModelClass) {
        return restObjectModelClass.isParamEntriesPresent() || restObjectModelClass.isHeadersPresent() || restObjectModelClass.isInternalsPresent();
    }

    private RestObjectModelClass getModelClass(EnvironmentContext environmentContext, TypeElement exceptionTypeElement) {
        ModuleElement currentModule = environmentContext.getCurrentModule();
        ModelFieldBuilderOptions options = new ModelFieldBuilderOptions().setWithFieldsFromParentClasses(false).setAccessViaReflectionMustBeDetected(false);
        Map map = this.modelFieldBuilder.build(ModelFieldType.REST_SERVER_RESPONSE, currentModule, Set.of(exceptionTypeElement), options);
        return this.validate((RestObjectModelClass)map.get(exceptionTypeElement));
    }

    private RestObjectModelClass validate(RestObjectModelClass restObjectModelClass) {
        for (RestModelField internal : restObjectModelClass.getInternals()) {
            if (internal.getAnnotation(ResponseStatusCode.class) == null) continue;
            throw new InterruptProcessingException(internal.getElementAnnotatedBy(ResponseStatusCode.class), "'@?' annotation can't be used for custom exception type! Remove this annotation!", new Object[]{ResponseStatusCode.class.getName()});
        }
        return restObjectModelClass;
    }
}

