/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.rest.server;

import com.google.inject.Inject;
import com.google.inject.Module;
import io.rxmicro.annotation.processor.common.CommonDependenciesModule;
import io.rxmicro.annotation.processor.common.FormatSourceCodeDependenciesModule;
import io.rxmicro.annotation.processor.common.component.ModuleGeneratorConfigBuilder;
import io.rxmicro.annotation.processor.common.component.WithParentClassStructureInitializer;
import io.rxmicro.annotation.processor.common.component.impl.AbstractModuleClassStructuresBuilder;
import io.rxmicro.annotation.processor.common.model.ClassStructure;
import io.rxmicro.annotation.processor.common.model.EnvironmentContext;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingBecauseAFewErrorsFoundException;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.common.util.Elements;
import io.rxmicro.annotation.processor.common.util.Injects;
import io.rxmicro.annotation.processor.common.util.LoggerMessages;
import io.rxmicro.annotation.processor.rest.RestCommonDependenciesModule;
import io.rxmicro.annotation.processor.rest.component.RestGenerationContextBuilder;
import io.rxmicro.annotation.processor.rest.component.RestModelFromJsonConverterBuilder;
import io.rxmicro.annotation.processor.rest.component.RestModelToJsonConverterBuilder;
import io.rxmicro.annotation.processor.rest.component.RestModelValidatorBuilder;
import io.rxmicro.annotation.processor.rest.model.HttpMethodMapping;
import io.rxmicro.annotation.processor.rest.model.MappedRestObjectModelClass;
import io.rxmicro.annotation.processor.rest.model.RestGenerationContext;
import io.rxmicro.annotation.processor.rest.model.VirtualTypeClassStructure;
import io.rxmicro.annotation.processor.rest.server.RestServerDependenciesModule;
import io.rxmicro.annotation.processor.rest.server.component.CrossOriginResourceSharingResourceBuilder;
import io.rxmicro.annotation.processor.rest.server.component.CustomExceptionMappedRestObjectModelClassBuilder;
import io.rxmicro.annotation.processor.rest.server.component.DeclaredStaticResourcesResolver;
import io.rxmicro.annotation.processor.rest.server.component.HttpHealthCheckBuilder;
import io.rxmicro.annotation.processor.rest.server.component.ModelReaderBuilder;
import io.rxmicro.annotation.processor.rest.server.component.ModelWriterBuilder;
import io.rxmicro.annotation.processor.rest.server.component.RestControllerClassSignatureBuilder;
import io.rxmicro.annotation.processor.rest.server.component.RestControllerClassStructureBuilder;
import io.rxmicro.annotation.processor.rest.server.component.RestDocumentationGenerator;
import io.rxmicro.annotation.processor.rest.server.model.DeclaredStaticResources;
import io.rxmicro.annotation.processor.rest.server.model.RestControllerAggregatorClassStructure;
import io.rxmicro.annotation.processor.rest.server.model.RestControllerClassSignature;
import io.rxmicro.annotation.processor.rest.server.model.RestControllerClassStructure;
import io.rxmicro.annotation.processor.rest.server.model.RestControllerClassStructureStorage;
import io.rxmicro.annotation.processor.rest.server.model.RestControllerMethodSignature;
import io.rxmicro.annotation.processor.rest.server.model.RestServerModuleGeneratorConfig;
import io.rxmicro.common.util.Formats;
import io.rxmicro.rest.method.DELETE;
import io.rxmicro.rest.method.GET;
import io.rxmicro.rest.method.HEAD;
import io.rxmicro.rest.method.HttpMethods;
import io.rxmicro.rest.method.OPTIONS;
import io.rxmicro.rest.method.PATCH;
import io.rxmicro.rest.method.POST;
import io.rxmicro.rest.method.PUT;
import io.rxmicro.rest.model.ExchangeFormat;
import io.rxmicro.rest.server.StaticResources;
import io.rxmicro.validation.DisableValidation;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;

public final class RestServerModuleClassStructuresBuilder
extends AbstractModuleClassStructuresBuilder {
    @Inject
    private ModuleGeneratorConfigBuilder<RestServerModuleGeneratorConfig> restServerModuleGeneratorConfigBuilder;
    @Inject
    private RestControllerClassSignatureBuilder restControllerClassSignatureBuilder;
    @Inject
    private RestGenerationContextBuilder restGenerationContextBuilder;
    @Inject
    private RestControllerClassStructureBuilder restControllerClassStructureBuilder;
    @Inject
    private ModelReaderBuilder modelReaderBuilder;
    @Inject
    private ModelWriterBuilder modelWriterBuilder;
    @Inject
    private CustomExceptionMappedRestObjectModelClassBuilder customExceptionMappedRestObjectModelClassBuilder;
    @Inject
    private RestModelValidatorBuilder restModelValidatorBuilder;
    @Inject
    private RestModelToJsonConverterBuilder restModelToJsonConverterBuilder;
    @Inject
    private RestModelFromJsonConverterBuilder restModelFromJsonConverterBuilder;
    @Inject
    private CrossOriginResourceSharingResourceBuilder crossOriginResourceSharingResourceBuilder;
    @Inject
    private HttpHealthCheckBuilder httpHealthCheckBuilder;
    @Inject
    private RestDocumentationGenerator restDocumentationGenerator;
    @Inject
    private WithParentClassStructureInitializer withParentClassStructureInitializer;
    @Inject
    private DeclaredStaticResourcesResolver declaredStaticResourcesResolver;

    public static RestServerModuleClassStructuresBuilder create() {
        RestServerModuleClassStructuresBuilder builder = new RestServerModuleClassStructuresBuilder();
        Injects.injectDependencies((Object)((Object)builder), (Module[])new Module[]{new FormatSourceCodeDependenciesModule(), new CommonDependenciesModule(), new RestCommonDependenciesModule(), new RestServerDependenciesModule()});
        return builder;
    }

    private RestServerModuleClassStructuresBuilder() {
    }

    public String getBuilderName() {
        return "rest-server-annotation-processor-module";
    }

    public Set<String> getSupportedAnnotationTypes() {
        return Stream.of(HttpMethods.HTTP_METHOD_ANNOTATIONS.stream().map(Class::getName), Stream.of(GET.List.class, POST.List.class, PUT.List.class, DELETE.List.class, PATCH.List.class, OPTIONS.List.class, HEAD.List.class).map(cl -> cl.getName().replace("$", ".")), Stream.of(StaticResources.class.getName(), StaticResources.List.class.getName().replace("$", "."))).flatMap(Function.identity()).collect(Collectors.toSet());
    }

    public Set<? extends ClassStructure> buildClassStructures(EnvironmentContext environmentContext, Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            Map<Boolean, List<TypeElement>> groups = annotations.stream().collect(Collectors.groupingBy(typeElement -> typeElement.getQualifiedName().toString().startsWith(StaticResources.class.getName())));
            List httpMethodAnnotations = Optional.ofNullable(groups.get(false)).orElse(List.of());
            List staticResourceAnnotations = Optional.ofNullable(groups.get(true)).orElse(List.of());
            Set<RestControllerClassSignature> classSignatures = this.restControllerClassSignatureBuilder.build(environmentContext, httpMethodAnnotations, roundEnv);
            DeclaredStaticResources declaredStaticResources = this.declaredStaticResourcesResolver.resolve(environmentContext, staticResourceAnnotations, roundEnv);
            if (!classSignatures.isEmpty()) {
                return this.buildClassStructures(environmentContext, classSignatures, declaredStaticResources);
            }
            if (declaredStaticResources.exist()) {
                this.logFoundStaticResources(declaredStaticResources);
                return Set.of(new RestControllerAggregatorClassStructure(environmentContext, Set.of(), Set.of(), this.httpHealthCheckBuilder.build(environmentContext, Set.of()), declaredStaticResources, Set.of()));
            }
            return Set.of();
        }
        catch (InterruptProcessingException ex) {
            this.error(ex);
            return Set.of();
        }
        catch (InterruptProcessingBecauseAFewErrorsFoundException ignore) {
            return Set.of();
        }
    }

    private Set<ClassStructure> buildClassStructures(EnvironmentContext environmentContext, Set<RestControllerClassSignature> classSignatures, DeclaredStaticResources declaredStaticResources) {
        environmentContext.put(this.restServerModuleGeneratorConfigBuilder.build(environmentContext));
        this.logFoundRestControllers(classSignatures);
        if (declaredStaticResources.exist()) {
            this.logFoundStaticResources(declaredStaticResources);
        }
        RestGenerationContext restGenerationContext = this.restGenerationContextBuilder.build(environmentContext, RestServerModuleGeneratorConfig.class, classSignatures);
        RestControllerClassStructureStorage restControllerClassStructureStorage = this.buildRestClassStructureStorage(environmentContext, restGenerationContext);
        HashSet<ClassStructure> classStructures = new HashSet<ClassStructure>(restControllerClassStructureStorage.getAll());
        Set<RestControllerClassStructure> restControllerClassStructures = this.restControllerClassStructureBuilder.build(environmentContext, restControllerClassStructureStorage, classSignatures);
        classStructures.addAll(restControllerClassStructures);
        classStructures.add(new RestControllerAggregatorClassStructure(environmentContext, restControllerClassStructures, this.crossOriginResourceSharingResourceBuilder.build(restControllerClassStructures, restGenerationContext), this.httpHealthCheckBuilder.build(environmentContext, restControllerClassStructures), declaredStaticResources, restControllerClassStructureStorage.getCustomExceptionModelWriters()));
        if (!((RestServerModuleGeneratorConfig)environmentContext.get(RestServerModuleGeneratorConfig.class)).getDocumentationTypes().isEmpty()) {
            this.restDocumentationGenerator.generate(environmentContext, restControllerClassStructureStorage, restControllerClassStructures);
        }
        this.addAllVirtualRequestClassStructures(classStructures, classSignatures, restControllerClassStructureStorage);
        return classStructures;
    }

    private void logFoundStaticResources(DeclaredStaticResources declaredStaticResources) {
        this.info("Found the following static resources:\n?", new Object[]{declaredStaticResources.getStaticUrls().stream().map(url -> Formats.format((String)"?'GET ?'", (Object[])new Object[]{"  ", url})).collect(Collectors.joining("\n"))});
    }

    private void logFoundRestControllers(Set<RestControllerClassSignature> set) {
        if (this.isInfoEnabled()) {
            StringBuilder stringBuilder = new StringBuilder("Found the following REST controllers:\n");
            for (RestControllerClassSignature signature : set) {
                stringBuilder.append(Formats.format((String)"??:\n", (Object[])new Object[]{"  ", signature.getTypeElement().getQualifiedName()}));
                for (RestControllerMethodSignature methodSignature : signature.getMethodSignatures()) {
                    for (HttpMethodMapping httpMethodMapping : methodSignature.getHttpMethodMappings()) {
                        stringBuilder.append(Formats.format((String)"??'? ?' -> ?;\n", (Object[])new Object[]{"  ", "  ", httpMethodMapping.getMethod(), httpMethodMapping.getExactOrTemplateUri(), LoggerMessages.getLoggableMethodName((ExecutableElement)methodSignature.getExecutableElement())}));
                    }
                }
            }
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            this.info(stringBuilder.toString(), new Supplier[0]);
        }
    }

    private RestControllerClassStructureStorage buildRestClassStructureStorage(EnvironmentContext environmentContext, RestGenerationContext generationContext) {
        ExchangeFormat exchangeFormat = ((RestServerModuleGeneratorConfig)environmentContext.get(RestServerModuleGeneratorConfig.class)).getExchangeFormatModule().getExchangeFormat();
        List<MappedRestObjectModelClass> customExceptionModels = this.customExceptionMappedRestObjectModelClassBuilder.build(environmentContext);
        RestControllerClassStructureStorage.Builder builder = new RestControllerClassStructureStorage.Builder();
        this.addValidators(environmentContext, generationContext, customExceptionModels, builder);
        this.addModelReadersAndWriters(exchangeFormat, customExceptionModels, generationContext, builder);
        this.addModelJsonConverters(exchangeFormat, customExceptionModels, generationContext, builder);
        this.setParentsForExistingChildren(builder);
        this.logRestControllerClassStructureStorage(builder);
        return builder.build();
    }

    private void addModelReadersAndWriters(ExchangeFormat exchangeFormat, List<MappedRestObjectModelClass> customExceptionModels, RestGenerationContext generationContext, RestControllerClassStructureStorage.Builder builder) {
        builder.addModelReaders(this.modelReaderBuilder.build(generationContext.getFromHttpDataModelClasses(), exchangeFormat)).addModelWriters(this.modelWriterBuilder.build(generationContext.getToHttpDataModelClasses(), exchangeFormat)).addCustomExceptionModelWriters(this.modelWriterBuilder.build(customExceptionModels, exchangeFormat));
    }

    private void addModelJsonConverters(ExchangeFormat exchangeFormat, List<MappedRestObjectModelClass> customExceptionModels, RestGenerationContext generationContext, RestControllerClassStructureStorage.Builder builder) {
        builder.addModelFromJsonConverters(this.restModelFromJsonConverterBuilder.buildFromJson(generationContext.getFromHttpDataModelClasses(), exchangeFormat, false)).addModelToJsonConverters(this.restModelToJsonConverterBuilder.buildToJson(generationContext.getToHttpDataModelClasses(), exchangeFormat, false)).addModelToJsonConverters(this.restModelToJsonConverterBuilder.buildToJson(customExceptionModels, exchangeFormat, false));
    }

    private void addValidators(EnvironmentContext environmentContext, RestGenerationContext generationContext, List<MappedRestObjectModelClass> customExceptionModels, RestControllerClassStructureStorage.Builder builder) {
        if (((RestServerModuleGeneratorConfig)environmentContext.get(RestServerModuleGeneratorConfig.class)).isGenerateRequestValidators()) {
            builder.addRequestValidators(this.restModelValidatorBuilder.build(generationContext.getFromHttpDataModelClasses().stream().map(MappedRestObjectModelClass::getModelClass).filter(m -> this.isAnnotationPerPackageHierarchyAbsent(m.getModelTypeElement(), DisableValidation.class)).collect(Collectors.toList())));
        }
        if (((RestServerModuleGeneratorConfig)environmentContext.get(RestServerModuleGeneratorConfig.class)).isGenerateResponseValidators()) {
            builder.addResponseValidators(this.restModelValidatorBuilder.build(generationContext.getToHttpDataModelClasses().stream().map(MappedRestObjectModelClass::getModelClass).filter(m -> this.isAnnotationPerPackageHierarchyAbsent(m.getModelTypeElement(), DisableValidation.class)).collect(Collectors.toList())));
            builder.addCustomExceptionModelValidators(this.restModelValidatorBuilder.build(customExceptionModels.stream().map(MappedRestObjectModelClass::getModelClass).filter(m -> this.isAnnotationPerPackageHierarchyAbsent(m.getModelTypeElement(), DisableValidation.class)).collect(Collectors.toList())));
        }
    }

    private void setParentsForExistingChildren(RestControllerClassStructureStorage.Builder builder) {
        this.withParentClassStructureInitializer.setParentIfExists(builder.getRequestValidators());
        this.withParentClassStructureInitializer.setParentIfExists(builder.getResponseValidators());
        this.withParentClassStructureInitializer.setParentIfExists(builder.getModelReaders());
        this.withParentClassStructureInitializer.setParentIfExists(builder.getModelWriters());
        this.withParentClassStructureInitializer.setParentIfExists(builder.getModelFromJsonConverters());
        this.withParentClassStructureInitializer.setParentIfExists(builder.getModelToJsonConverters());
    }

    private void logRestControllerClassStructureStorage(RestControllerClassStructureStorage.Builder builder) {
        if (this.isDebugEnabled()) {
            this.logClassStructureStorageItem("request model reader(s)", builder.getModelReaders());
            this.logClassStructureStorageItem("request model converter(s)", builder.getModelFromJsonConverters());
            this.logClassStructureStorageItem("request validator(s)", builder.getRequestValidators());
            this.logClassStructureStorageItem("response model writer(s)", builder.getModelWriters());
            this.logClassStructureStorageItem("response model converter(s)", builder.getModelToJsonConverters());
            this.logClassStructureStorageItem("response validator(s)", builder.getResponseValidators());
        }
    }

    private void addAllVirtualRequestClassStructures(Set<ClassStructure> classStructures, Set<RestControllerClassSignature> classSignatures, RestControllerClassStructureStorage restControllerClassStructureStorage) {
        for (RestControllerClassSignature classSignature : classSignatures) {
            for (RestControllerMethodSignature methodSignature : classSignature.getMethodSignatures()) {
                methodSignature.getRequestModel().getRequestType().filter(Elements::isVirtualTypeElement).flatMap(t -> restControllerClassStructureStorage.getModelReaderClassStructure(t.getQualifiedName().toString())).ifPresent(mr -> classStructures.add((ClassStructure)new VirtualTypeClassStructure(mr.getModelClass(), false)));
            }
        }
    }
}

