/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.rest.client.model;

import io.rxmicro.annotation.processor.rest.client.model.RestClientClassSignature;
import io.rxmicro.annotation.processor.rest.model.HttpMethodMapping;
import io.rxmicro.annotation.processor.rest.model.RestMethodSignature;
import io.rxmicro.annotation.processor.rest.model.RestRequestModel;
import io.rxmicro.annotation.processor.rest.model.RestResponseModel;
import io.rxmicro.common.util.Formats;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;

public final class RestClientMethodSignature
implements RestMethodSignature {
    private final ExecutableElement method;
    private final String simpleName;
    private final RestRequestModel requestModel;
    private final RestResponseModel responseModel;
    private final HttpMethodMapping httpMethodMapping;
    private RestClientClassSignature restClientClassSignature;

    public RestClientMethodSignature(ExecutableElement method, RestRequestModel requestModel, RestResponseModel responseModel, HttpMethodMapping httpMethodMapping) {
        this.method = method;
        this.simpleName = method.getSimpleName().toString();
        this.requestModel = requestModel;
        this.responseModel = responseModel;
        this.httpMethodMapping = httpMethodMapping;
    }

    public RestClientClassSignature getRestClientClassSignature() {
        return this.restClientClassSignature;
    }

    void setRestClientClassSignature(RestClientClassSignature restClientClassSignature) {
        this.restClientClassSignature = restClientClassSignature;
    }

    public ExecutableElement getMethod() {
        return this.method;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public List<? extends VariableElement> getParameters() {
        return this.method.getParameters();
    }

    public RestRequestModel getRequestModel() {
        return this.requestModel;
    }

    public RestResponseModel getResponseModel() {
        return this.responseModel;
    }

    public List<HttpMethodMapping> getHttpMethodMappings() {
        return List.of(this.httpMethodMapping);
    }

    public Optional<TypeElement> getFromHttpDataType() {
        return this.responseModel.getResultType();
    }

    public Optional<TypeElement> getToHttpDataType() {
        return this.requestModel.getRequestType();
    }

    public HttpMethodMapping getHttpMethodMapping() {
        return this.httpMethodMapping;
    }

    public String toString() {
        return Formats.format((String)"?.?", (Object[])new Object[]{this.method.getEnclosingElement().asType(), Formats.format((String)"?(?)", (Object[])new Object[]{this.simpleName, this.method.getParameters().stream().map(p -> p.asType().toString()).collect(Collectors.joining(", "))})});
    }
}

