/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.rest.client.model;

import io.rxmicro.annotation.processor.common.model.method.MethodBody;
import io.rxmicro.annotation.processor.common.util.Names;
import io.rxmicro.annotation.processor.rest.client.model.RestClientClassStructureStorage;
import io.rxmicro.annotation.processor.rest.model.RestRequestModel;
import io.rxmicro.annotation.processor.rest.model.RestResponseModel;
import io.rxmicro.common.util.Formats;
import io.rxmicro.common.util.Requires;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

public final class RestClientMethod {
    private final ExecutableElement method;
    private final String methodName;
    private final RestRequestModel requestModel;
    private final MethodBody body;
    private final RestResponseModel responseModel;

    public RestClientMethod(ExecutableElement method, String methodName, RestRequestModel requestModel, MethodBody body, RestResponseModel responseModel) {
        this.method = (ExecutableElement)Requires.require((Object)method);
        this.methodName = (String)Requires.require((Object)methodName);
        this.requestModel = (RestRequestModel)Requires.require((Object)requestModel);
        this.body = (MethodBody)Requires.require((Object)body);
        this.responseModel = (RestResponseModel)Requires.require((Object)responseModel);
    }

    Optional<TypeElement> getFromHttpDataType() {
        return this.responseModel.getResultType();
    }

    boolean shouldGenerateModelExtractor(RestClientClassStructureStorage classStructureStorage) {
        return this.requestModel.getRequestType().map(t -> classStructureStorage.isRequestModelExtractorPresent(t.asType().toString())).orElse(false);
    }

    boolean shouldGeneratePathBuilder(RestClientClassStructureStorage classStructureStorage) {
        return this.requestModel.getRequestType().map(t -> classStructureStorage.isPathBuilderPresent(t.asType().toString())).orElse(false);
    }

    boolean shouldGenerateModelToHttpBodyConverter(RestClientClassStructureStorage classStructureStorage) {
        return this.requestModel.getRequestType().map(t -> classStructureStorage.isModelToJsonConverterPresent(t.asType().toString())).orElse(false);
    }

    boolean shouldGenerateModelReader(RestClientClassStructureStorage classStructureStorage) {
        return this.responseModel.getResultType().map(t -> classStructureStorage.isModelReaderPresent(t.asType().toString())).orElse(false);
    }

    boolean shouldGenerateRequestValidator(RestClientClassStructureStorage classStructureStorage) {
        return this.requestModel.getRequestType().map(t -> classStructureStorage.isRequestValidatorPresent(t.asType().toString())).orElse(false);
    }

    boolean shouldGenerateResponseValidator(RestClientClassStructureStorage classStructureStorage) {
        return this.responseModel.getResultType().map(t -> classStructureStorage.isResponseValidatorPresent(t.asType().toString())).orElse(false);
    }

    Optional<TypeElement> getToHttpDataType() {
        return this.requestModel.getRequestType();
    }

    public String getReturnType() {
        return this.responseModel.getHumanReadableReturnType();
    }

    public String getName() {
        return this.methodName;
    }

    public String getParams() {
        return this.method.getParameters().stream().map(e -> Formats.format((String)"final ? ?", (Object[])new Object[]{Names.getSimpleName((TypeMirror)e.asType()), e.getSimpleName().toString()})).collect(Collectors.joining(", "));
    }

    public List<String> getBodyLines() {
        return this.body.getLines();
    }
}

