/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.rest.client.model;

import io.rxmicro.annotation.processor.common.model.ClassStructure;
import io.rxmicro.annotation.processor.common.model.type.ObjectModelClass;
import io.rxmicro.annotation.processor.rest.client.model.ModelReaderClassStructure;
import io.rxmicro.annotation.processor.rest.client.model.PathBuilderClassStructure;
import io.rxmicro.annotation.processor.rest.client.model.RequestModelExtractorClassStructure;
import io.rxmicro.annotation.processor.rest.model.AbstractModelJsonConverterClassStructure;
import io.rxmicro.annotation.processor.rest.model.RestObjectModelClass;
import io.rxmicro.annotation.processor.rest.model.converter.ModelFromJsonConverterClassStructure;
import io.rxmicro.annotation.processor.rest.model.converter.ModelToJsonConverterClassStructure;
import io.rxmicro.annotation.processor.rest.model.validator.ModelValidatorClassStructure;
import io.rxmicro.common.util.Requires;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class RestClientClassStructureStorage {
    private final Map<String, RestObjectModelClass> modelClassMap;
    private final Map<String, ModelValidatorClassStructure> requestValidatorMap;
    private final Map<String, ModelValidatorClassStructure> responseValidatorMap;
    private final Map<String, PathBuilderClassStructure> pathBuilderMap;
    private final Map<String, RequestModelExtractorClassStructure> requestModelExtractorMap;
    private final Map<String, ModelReaderClassStructure> modelReaderMap;
    private final Map<String, ModelFromJsonConverterClassStructure> modelFromJsonConverterMap;
    private final Map<String, ModelToJsonConverterClassStructure> modelToJsonConverterMap;

    private RestClientClassStructureStorage(Map<String, RestObjectModelClass> modelClassMap, Map<String, ModelValidatorClassStructure> requestValidatorMap, Map<String, ModelValidatorClassStructure> responseValidatorMap, Map<String, PathBuilderClassStructure> pathBuilderMap, Map<String, RequestModelExtractorClassStructure> requestModelExtractorMap, Map<String, ModelReaderClassStructure> modelReaderMap, Map<String, ModelFromJsonConverterClassStructure> modelFromJsonConverterMap, Map<String, ModelToJsonConverterClassStructure> modelToJsonConverterMap) {
        this.modelClassMap = (Map)Requires.require(modelClassMap);
        this.requestValidatorMap = (Map)Requires.require(requestValidatorMap);
        this.responseValidatorMap = (Map)Requires.require(responseValidatorMap);
        this.pathBuilderMap = (Map)Requires.require(pathBuilderMap);
        this.requestModelExtractorMap = (Map)Requires.require(requestModelExtractorMap);
        this.modelReaderMap = (Map)Requires.require(modelReaderMap);
        this.modelFromJsonConverterMap = (Map)Requires.require(modelFromJsonConverterMap);
        this.modelToJsonConverterMap = (Map)Requires.require(modelToJsonConverterMap);
    }

    public boolean isPathBuilderPresent(String fullClassName) {
        return this.pathBuilderMap.containsKey(fullClassName);
    }

    public boolean isRequestModelExtractorPresent(String fullClassName) {
        return this.requestModelExtractorMap.containsKey(fullClassName);
    }

    public boolean isRequestValidatorPresent(String fullClassName) {
        return this.requestValidatorMap.containsKey(fullClassName);
    }

    public boolean isRequestValidatorsPresent() {
        return !this.requestValidatorMap.isEmpty();
    }

    public boolean isResponseValidatorPresent(String fullClassName) {
        return this.responseValidatorMap.containsKey(fullClassName);
    }

    public boolean isResponseValidatorsPresent() {
        return !this.responseValidatorMap.isEmpty();
    }

    public boolean isModelReaderPresent(String fullClassName) {
        return this.modelReaderMap.containsKey(fullClassName);
    }

    public boolean isModelToJsonConverterPresent(String fullClassName) {
        return this.modelToJsonConverterMap.containsKey(fullClassName);
    }

    public Optional<RestObjectModelClass> getModelClass(String fullClassName) {
        return Optional.ofNullable(this.modelClassMap.get(fullClassName));
    }

    public Set<ClassStructure> getAll() {
        return Stream.of(this.requestValidatorMap.values().stream().map(s -> s), this.responseValidatorMap.values().stream().map(s -> s), this.pathBuilderMap.values().stream().map(s -> s), this.requestModelExtractorMap.values().stream().map(s -> s), this.modelReaderMap.values().stream().map(s -> s), this.modelFromJsonConverterMap.values().stream().map(s -> s), this.modelToJsonConverterMap.values().stream().map(s -> s)).flatMap(Function.identity()).collect(Collectors.toSet());
    }

    public static final class Builder {
        private final Set<RestObjectModelClass> restClientObjectModelClasses = new TreeSet<RestObjectModelClass>();
        private final Set<ModelValidatorClassStructure> requestValidators = new TreeSet<ModelValidatorClassStructure>();
        private final Set<ModelValidatorClassStructure> responseValidators = new TreeSet<ModelValidatorClassStructure>();
        private final Set<PathBuilderClassStructure> pathBuilders = new TreeSet<PathBuilderClassStructure>();
        private final Set<ModelReaderClassStructure> modelReaders = new TreeSet<ModelReaderClassStructure>();
        private final Set<RequestModelExtractorClassStructure> requestModelExtractors = new TreeSet<RequestModelExtractorClassStructure>();
        private final Set<ModelFromJsonConverterClassStructure> modelFromJsonConverters = new TreeSet<ModelFromJsonConverterClassStructure>();
        private final Set<ModelToJsonConverterClassStructure> modelToJsonConverters = new TreeSet<ModelToJsonConverterClassStructure>();

        public void addRestObjectModelClasses(Set<RestObjectModelClass> restObjectModelClasses) {
            this.restClientObjectModelClasses.addAll(restObjectModelClasses);
        }

        public void addRequestValidators(Set<ModelValidatorClassStructure> requestValidators) {
            this.requestValidators.addAll(requestValidators);
        }

        public void addResponseValidators(Set<ModelValidatorClassStructure> responseValidators) {
            this.responseValidators.addAll(responseValidators);
        }

        public Builder addPathBuilders(Set<PathBuilderClassStructure> pathBuilders) {
            this.pathBuilders.addAll(pathBuilders);
            return this;
        }

        public Builder addModelReaders(Set<ModelReaderClassStructure> modelReaders) {
            this.modelReaders.addAll(modelReaders);
            return this;
        }

        public Builder addRequestModelExtractors(Set<RequestModelExtractorClassStructure> requestModelExtractors) {
            this.requestModelExtractors.addAll(requestModelExtractors);
            return this;
        }

        public Builder addModelFromJsonConverters(Set<ModelFromJsonConverterClassStructure> modelFromJsonConverters) {
            this.modelFromJsonConverters.addAll(modelFromJsonConverters);
            return this;
        }

        public Builder addModelToJsonConverters(Set<ModelToJsonConverterClassStructure> modelToJsonConverters) {
            this.modelToJsonConverters.addAll(modelToJsonConverters);
            return this;
        }

        public Set<RestObjectModelClass> getRestClientObjectModelClasses() {
            return this.restClientObjectModelClasses;
        }

        public Set<ModelValidatorClassStructure> getRequestValidators() {
            return this.requestValidators;
        }

        public Set<ModelValidatorClassStructure> getResponseValidators() {
            return this.responseValidators;
        }

        public Set<PathBuilderClassStructure> getPathBuilders() {
            return this.pathBuilders;
        }

        public Set<ModelReaderClassStructure> getModelReaders() {
            return this.modelReaders;
        }

        public Set<RequestModelExtractorClassStructure> getRequestModelExtractors() {
            return this.requestModelExtractors;
        }

        public Set<ModelFromJsonConverterClassStructure> getModelFromJsonConverters() {
            return this.modelFromJsonConverters;
        }

        public Set<ModelToJsonConverterClassStructure> getModelToJsonConverters() {
            return this.modelToJsonConverters;
        }

        public RestClientClassStructureStorage build() {
            return new RestClientClassStructureStorage(this.restClientObjectModelClasses.stream().collect(Collectors.toMap(ObjectModelClass::getJavaFullClassName, Function.identity())), this.requestValidators.stream().collect(Collectors.toMap(ModelValidatorClassStructure::getModelFullClassName, Function.identity())), this.responseValidators.stream().collect(Collectors.toMap(ModelValidatorClassStructure::getModelFullClassName, Function.identity())), this.pathBuilders.stream().collect(Collectors.toMap(PathBuilderClassStructure::getModelFullClassName, Function.identity())), this.requestModelExtractors.stream().collect(Collectors.toMap(RequestModelExtractorClassStructure::getModelFullClassName, Function.identity())), this.modelReaders.stream().collect(Collectors.toMap(ModelReaderClassStructure::getModelFullClassName, Function.identity())), this.modelFromJsonConverters.stream().collect(Collectors.toMap(AbstractModelJsonConverterClassStructure::getModelFullClassName, Function.identity())), this.modelToJsonConverters.stream().collect(Collectors.toMap(AbstractModelJsonConverterClassStructure::getModelFullClassName, Function.identity())));
        }
    }
}

