/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.rest.client.model;

import io.rxmicro.annotation.processor.common.model.ClassHeader;
import io.rxmicro.annotation.processor.common.model.ClassStructure;
import io.rxmicro.annotation.processor.common.model.DefaultConfigProxyValue;
import io.rxmicro.annotation.processor.common.model.ModelTransformer;
import io.rxmicro.annotation.processor.common.model.virtual.VirtualFieldElement;
import io.rxmicro.annotation.processor.common.model.virtual.VirtualTypeElement;
import io.rxmicro.annotation.processor.common.util.Elements;
import io.rxmicro.annotation.processor.common.util.Names;
import io.rxmicro.annotation.processor.rest.client.model.RestClientClassStructureStorage;
import io.rxmicro.annotation.processor.rest.client.model.RestClientMethod;
import io.rxmicro.annotation.processor.rest.client.model.RestClientSimpleObjectModelClass;
import io.rxmicro.annotation.processor.rest.model.AbstractSimpleObjectModelClass;
import io.rxmicro.common.util.ExCollections;
import io.rxmicro.common.util.Requires;
import io.rxmicro.exchange.json.detail.ModelToJsonConverter;
import io.rxmicro.rest.client.detail.HttpClient;
import io.rxmicro.rest.client.detail.HttpResponse;
import io.rxmicro.rest.client.detail.ModelReader;
import io.rxmicro.rest.client.detail.PathBuilder;
import io.rxmicro.rest.client.detail.RequestModelExtractor;
import io.rxmicro.validation.detail.RequestValidators;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

public final class RestClientClassStructure
extends ClassStructure {
    private final ClassHeader.Builder classHeaderBuilder;
    private final String configNameSpace;
    private final List<Map.Entry<String, DefaultConfigProxyValue>> defaultConfigValues;
    private final TypeElement httpClientConfigClass;
    private final TypeElement restClientInterface;
    private final TypeElement restClientAbstractClass;
    private final List<RestClientMethod> methods;
    private final RestClientClassStructureStorage classStructureStorage;
    private final Set<ModelTransformer> modelTransformers;
    private final Set<AbstractSimpleObjectModelClass> allValidators;

    public RestClientClassStructure(ClassHeader.Builder classHeaderBuilder, String configNameSpace, List<Map.Entry<String, DefaultConfigProxyValue>> defaultConfigValues, TypeElement httpClientConfigClass, TypeElement restClientInterface, TypeElement restClientAbstractClass, List<RestClientMethod> methods, RestClientClassStructureStorage classStructureStorage) {
        this.classHeaderBuilder = (ClassHeader.Builder)Requires.require((Object)classHeaderBuilder);
        this.configNameSpace = configNameSpace;
        this.defaultConfigValues = defaultConfigValues;
        this.httpClientConfigClass = httpClientConfigClass;
        this.restClientInterface = (TypeElement)Requires.require((Object)restClientInterface);
        this.restClientAbstractClass = (TypeElement)Requires.require((Object)restClientAbstractClass);
        this.methods = (List)Requires.require(methods);
        this.classStructureStorage = classStructureStorage;
        this.modelTransformers = Stream.of(methods.stream().filter(m -> m.shouldGeneratePathBuilder(classStructureStorage)).flatMap(m -> m.getToHttpDataType().stream()).map(cl -> new ModelTransformer(cl.asType(), PathBuilder.class)), methods.stream().filter(m -> m.shouldGenerateModelExtractor(classStructureStorage)).flatMap(m -> m.getToHttpDataType().stream()).map(cl -> new ModelTransformer(cl.asType(), RequestModelExtractor.class)), methods.stream().filter(m -> m.shouldGenerateModelToHttpBodyConverter(classStructureStorage)).flatMap(m -> m.getToHttpDataType().stream()).map(cl -> new ModelTransformer(cl.asType(), ModelToJsonConverter.class)), methods.stream().filter(m -> m.shouldGenerateModelReader(classStructureStorage)).flatMap(m -> m.getFromHttpDataType().stream()).map(cl -> new ModelTransformer(cl.asType(), ModelReader.class))).flatMap(Function.identity()).collect(Collectors.toSet());
        this.allValidators = ExCollections.join((Set[])new Set[]{this.getRequestValidators(), this.getResponseValidators()});
    }

    public List<Map.Entry<String, DefaultConfigProxyValue>> getDefaultConfigValues() {
        return this.defaultConfigValues;
    }

    public String getSimpleInterfaceName() {
        return Names.getSimpleName((String)this.getFullInterfaceName());
    }

    public String getConfigNameSpace() {
        return this.configNameSpace;
    }

    public TypeElement getHttpClientConfigFullClassName() {
        return this.httpClientConfigClass;
    }

    public String getHttpClientConfigSimpleClassName() {
        return Names.getSimpleName((TypeElement)this.httpClientConfigClass);
    }

    public String getFullInterfaceName() {
        return this.restClientInterface.getQualifiedName().toString();
    }

    public String getTargetFullClassName() {
        return Names.getPackageName((TypeElement)this.restClientInterface) + ".$$" + this.restClientInterface.getSimpleName();
    }

    public String getTemplateName() {
        return "rest/client/$$RestClientTemplate.javaftl";
    }

    public Map<String, Object> getTemplateVariables() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PREFIX", "$$");
        map.put("JAVA_REST_CLIENT_INTERFACE", this.restClientInterface.getSimpleName());
        map.put("JAVA_REST_CLIENT_ABSTRACT_CLASS", this.restClientAbstractClass.getSimpleName());
        map.put("JAVA_REST_CLIENT_METHODS", this.methods);
        map.put("JAVA_MODEL_TRANSFORMERS", this.modelTransformers);
        map.put("JAVA_VALIDATED_MODEL_CLASSES", this.allValidators);
        map.put("CONFIG_CLASS", this.getHttpClientConfigSimpleClassName());
        return map;
    }

    public ClassHeader getClassHeader() {
        this.classHeaderBuilder.addImports(new Class[]{CompletableFuture.class, HttpClient.class, HttpResponse.class}).addImports(new TypeElement[]{this.restClientAbstractClass}).addStaticImport(RequestValidators.class, "validateRequest");
        this.classHeaderBuilder.addImports(new TypeElement[]{this.getHttpClientConfigFullClassName()});
        this.allValidators.forEach(v -> this.classHeaderBuilder.addImports(new String[]{v.getModelValidatorImplFullClassName()}));
        this.modelTransformers.forEach(c -> this.classHeaderBuilder.addImports(new String[]{c.getJavaFullClassName()}));
        this.methods.stream().flatMap(m -> m.getToHttpDataType().stream()).filter(Elements::isVirtualTypeElement).forEach(typeElement -> this.classHeaderBuilder.addImports((TypeMirror[])((VirtualTypeElement)typeElement).getVirtualFieldElements().stream().map(VirtualFieldElement::asType).toArray(TypeMirror[]::new)));
        return this.classHeaderBuilder.build();
    }

    private Set<AbstractSimpleObjectModelClass> getRequestValidators() {
        HashSet<AbstractSimpleObjectModelClass> simpleObjectModelClasses = new HashSet<AbstractSimpleObjectModelClass>();
        if (this.classStructureStorage.isRequestValidatorsPresent()) {
            simpleObjectModelClasses.addAll(this.methods.stream().filter(m -> m.shouldGenerateRequestValidator(this.classStructureStorage)).flatMap(m -> m.getToHttpDataType().stream()).map(RestClientSimpleObjectModelClass::new).collect(Collectors.toSet()));
        }
        return simpleObjectModelClasses;
    }

    private Set<AbstractSimpleObjectModelClass> getResponseValidators() {
        HashSet<AbstractSimpleObjectModelClass> simpleObjectModelClasses = new HashSet<AbstractSimpleObjectModelClass>();
        if (this.classStructureStorage.isResponseValidatorsPresent()) {
            simpleObjectModelClasses.addAll(this.methods.stream().filter(m -> m.shouldGenerateResponseValidator(this.classStructureStorage)).flatMap(m -> m.getFromHttpDataType().stream()).map(RestClientSimpleObjectModelClass::new).collect(Collectors.toSet()));
        }
        return simpleObjectModelClasses;
    }
}

