/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.rest.client.model;

import io.rxmicro.annotation.processor.common.model.TypeSignature;
import io.rxmicro.annotation.processor.rest.client.model.RestClientMethodSignature;
import io.rxmicro.annotation.processor.rest.model.ParentUrl;
import io.rxmicro.annotation.processor.rest.model.RestClassSignature;
import io.rxmicro.common.util.ExCollections;
import io.rxmicro.common.util.Requires;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.TypeElement;

public final class RestClientClassSignature
extends TypeSignature
implements RestClassSignature {
    private final ParentUrl parentUrl;
    private final TypeElement restClientInterface;
    private final TypeElement restClientAbstractClass;
    private final List<RestClientMethodSignature> methodSignatures;

    public RestClientClassSignature(ParentUrl parentUrl, TypeElement restClientInterface, TypeElement restClientAbstractClass, List<RestClientMethodSignature> methodSignatures) {
        this.parentUrl = (ParentUrl)Requires.require((Object)parentUrl);
        this.restClientInterface = (TypeElement)Requires.require((Object)restClientInterface);
        this.restClientAbstractClass = (TypeElement)Requires.require((Object)restClientAbstractClass);
        this.methodSignatures = ExCollections.unmodifiableList(methodSignatures);
        this.methodSignatures.forEach(methodSignature -> methodSignature.setRestClientClassSignature(this));
    }

    public TypeElement getRestClientInterface() {
        return this.restClientInterface;
    }

    public TypeElement getRestClientAbstractClass() {
        return this.restClientAbstractClass;
    }

    public ParentUrl getParentUrl() {
        return this.parentUrl;
    }

    protected String getTypeFullName() {
        return this.restClientInterface.getQualifiedName().toString();
    }

    public Set<TypeElement> getFromHttpDataModelTypes() {
        return this.methodSignatures.stream().flatMap(m -> m.getResponseModel().getResultType().stream()).collect(Collectors.toSet());
    }

    public Set<TypeElement> getToHttpDataModelTypes() {
        return this.methodSignatures.stream().flatMap(m -> m.getRequestModel().getRequestType().stream()).collect(Collectors.toSet());
    }

    public List<RestClientMethodSignature> getMethodSignatures() {
        return this.methodSignatures;
    }
}

