/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.rest.client.model;

import io.rxmicro.annotation.processor.common.model.ClassHeader;
import io.rxmicro.annotation.processor.common.model.ClassStructure;
import io.rxmicro.annotation.processor.common.model.ModelAccessorType;
import io.rxmicro.annotation.processor.common.model.error.InternalErrorException;
import io.rxmicro.annotation.processor.common.model.type.ObjectModelClass;
import io.rxmicro.annotation.processor.common.util.GeneratedClassNames;
import io.rxmicro.annotation.processor.rest.model.HttpMethodMapping;
import io.rxmicro.annotation.processor.rest.model.RestModelField;
import io.rxmicro.annotation.processor.rest.model.RestObjectModelClass;
import io.rxmicro.common.util.Formats;
import io.rxmicro.common.util.Requires;
import io.rxmicro.rest.client.detail.PathBuilder;
import io.rxmicro.rest.model.UrlSegments;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.lang.model.element.TypeElement;

public final class PathBuilderClassStructure
extends ClassStructure {
    private final RestObjectModelClass modelClass;
    private final List<HttpMethodMapping> httpMethodMappings;

    public PathBuilderClassStructure(RestObjectModelClass modelClass, List<HttpMethodMapping> httpMethodMappings) {
        this.modelClass = (RestObjectModelClass)Requires.require((Object)modelClass);
        this.httpMethodMappings = (List)Requires.require(httpMethodMappings);
    }

    public String getModelFullClassName() {
        return this.modelClass.getJavaFullClassName();
    }

    public String getTargetFullClassName() {
        return GeneratedClassNames.getModelTransformerFullClassName((TypeElement)this.modelClass.getModelTypeElement(), PathBuilder.class);
    }

    public String getTemplateName() {
        return "rest/client/$$RestClientPathBuilderTemplate.javaftl";
    }

    public Map<String, Object> getTemplateVariables() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("JAVA_MODEL_CLASS", this.modelClass);
        List<Map.Entry<UrlSegments, List<String>>> urlTemplates = this.getUrlTemplates();
        if (urlTemplates.size() == 1) {
            map.put("SINGLE", urlTemplates.get(0));
        } else {
            map.put("URL_TEMPLATES", urlTemplates);
        }
        return map;
    }

    public ClassHeader getClassHeader() {
        ClassHeader.Builder classHeaderBuilder = ClassHeader.newClassHeaderBuilder((ObjectModelClass)this.modelClass).addImports(new Class[]{PathBuilder.class});
        if (this.isRequiredReflectionGetter()) {
            classHeaderBuilder.addStaticImport(GeneratedClassNames.REFLECTIONS_FULL_CLASS_NAME, "getFieldValue");
        }
        return classHeaderBuilder.build();
    }

    public boolean isRequiredReflectionGetter() {
        return this.modelClass.isReadReflectionRequired();
    }

    private List<Map.Entry<UrlSegments, List<String>>> getUrlTemplates() {
        ArrayList<Map.Entry<UrlSegments, List<String>>> list = new ArrayList<Map.Entry<UrlSegments, List<String>>>();
        Map pathVariableMap = this.modelClass.getPathVariableMap();
        HashSet<String> originalUrls = new HashSet<String>();
        for (HttpMethodMapping httpMethodMapping : this.httpMethodMappings) {
            UrlSegments urlSegments = httpMethodMapping.getUrlSegments();
            if (!originalUrls.add(urlSegments.getOriginalUrl())) continue;
            List args = urlSegments.getVariables().stream().map(v -> (RestModelField)Requires.require((Object)((RestModelField)pathVariableMap.get(v)))).map(f -> {
                if (f.getModelReadAccessorType() == ModelAccessorType.REFLECTION) {
                    return Formats.format((String)"getFieldValue(model, \"?\")", (Object[])new Object[]{f.getFieldName()});
                }
                if (f.getModelReadAccessorType() == ModelAccessorType.DIRECT) {
                    return Formats.format((String)"model.?", (Object[])new Object[]{f.getFieldName()});
                }
                if (f.getModelReadAccessorType() == ModelAccessorType.JAVA_BEAN) {
                    return Formats.format((String)"model.?()", (Object[])new Object[]{f.getGetter()});
                }
                throw new InternalErrorException("Unsupported ModelAccessorType: " + f.getModelReadAccessorType(), new Object[0]);
            }).collect(Collectors.toList());
            list.add(Map.entry(urlSegments, args));
        }
        return list;
    }
}

