/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.rest.client.model;

import io.rxmicro.annotation.processor.common.model.ClassHeader;
import io.rxmicro.annotation.processor.common.model.ClassStructure;
import io.rxmicro.annotation.processor.common.model.error.InternalErrorException;
import io.rxmicro.annotation.processor.common.util.GeneratedClassNames;
import io.rxmicro.annotation.processor.rest.client.model.ModelReaderType;
import io.rxmicro.annotation.processor.rest.model.RestObjectModelClass;
import io.rxmicro.common.util.Requires;
import io.rxmicro.http.HttpHeaders;
import io.rxmicro.rest.client.detail.HttpResponse;
import io.rxmicro.rest.client.detail.ModelReader;
import io.rxmicro.rest.model.ExchangeFormat;
import io.rxmicro.rest.model.HttpModelType;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.TypeElement;

public final class ModelReaderClassStructure
extends ClassStructure {
    private final RestObjectModelClass modelClass;
    private final ExchangeFormat exchangeFormat;
    private final ModelReaderType modelReaderType;

    public ModelReaderClassStructure(RestObjectModelClass modelClass, ExchangeFormat exchangeFormat, ModelReaderType modelReaderType) {
        this.modelClass = (RestObjectModelClass)Requires.require((Object)modelClass);
        this.exchangeFormat = (ExchangeFormat)Requires.require((Object)exchangeFormat);
        this.modelReaderType = modelReaderType;
    }

    public String getModelFullClassName() {
        return this.modelClass.getJavaFullClassName();
    }

    public String getTargetFullClassName() {
        return GeneratedClassNames.getModelTransformerFullClassName((TypeElement)this.modelClass.getModelTypeElement(), ModelReader.class);
    }

    public String getTemplateName() {
        if (this.exchangeFormat == ExchangeFormat.JSON_EXCHANGE_FORMAT) {
            return "rest/client/$$RestJsonModelReaderTemplate.javaftl";
        }
        throw new InternalErrorException("Not impl yet", new Object[0]);
    }

    public Map<String, Object> getTemplateVariables() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("JAVA_MODEL_CLASS", this.modelClass);
        map.put("READER_TYPE", (Object)this.modelReaderType);
        map.put("WITH_BODY", this.modelClass.isParamEntriesPresent());
        return map;
    }

    public ClassHeader getClassHeader() {
        ClassHeader.Builder classHeaderBuilder = ClassHeader.newClassHeaderBuilder((TypeElement)this.modelClass.getModelTypeElement()).addImports(new Class[]{HttpResponse.class, ModelReader.class, List.class, HttpHeaders.class, HttpModelType.class}).addImports((Collection)this.modelClass.getModelFieldTypes());
        if (this.isRequiredReflectionSetter()) {
            classHeaderBuilder.addStaticImport(GeneratedClassNames.REFLECTIONS_FULL_CLASS_NAME, "setFieldValue");
        }
        return classHeaderBuilder.build();
    }

    public boolean isRequiredReflectionSetter() {
        return this.modelClass.isInternalsReadReflectionRequired() || this.modelClass.isHeaderReadReflectionRequired();
    }
}

