/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.rest.client.component.impl.method;

import io.rxmicro.annotation.processor.common.model.ClassHeader;
import io.rxmicro.annotation.processor.common.model.EnvironmentContext;
import io.rxmicro.annotation.processor.common.model.method.MethodBody;
import io.rxmicro.annotation.processor.common.model.virtual.VirtualTypeElement;
import io.rxmicro.annotation.processor.common.util.Elements;
import io.rxmicro.annotation.processor.common.util.GeneratedClassNames;
import io.rxmicro.annotation.processor.rest.client.component.impl.BaseRestClientMethodBodyBuilder;
import io.rxmicro.annotation.processor.rest.client.model.RestClientClassStructureStorage;
import io.rxmicro.annotation.processor.rest.client.model.RestClientMethodBody;
import io.rxmicro.annotation.processor.rest.client.model.RestClientMethodSignature;
import io.rxmicro.annotation.processor.rest.model.RestObjectModelClass;
import io.rxmicro.annotation.processor.rest.model.RestRequestModel;
import io.rxmicro.annotation.processor.rest.model.RestResponseModel;
import io.rxmicro.annotation.processor.rest.model.StaticHeaders;
import io.rxmicro.annotation.processor.rest.model.StaticQueryParameters;
import io.rxmicro.rest.client.detail.RequestModelExtractor;
import java.util.Map;
import javax.lang.model.element.TypeElement;

public abstract class AbstractParametrizedBaseRestClientMethodBodyBuilder
extends BaseRestClientMethodBodyBuilder {
    protected abstract String getTemplateName();

    @Override
    public final MethodBody build(EnvironmentContext environmentContext, RestClientClassStructureStorage storage, ClassHeader.Builder classHeaderBuilder, StaticHeaders staticHeaders, StaticQueryParameters staticQueryParameters, RestClientMethodSignature methodSignature) {
        this.validate(methodSignature, staticQueryParameters);
        this.customizeClassHeaderBuilder(classHeaderBuilder);
        RestRequestModel requestModel = methodSignature.getRequestModel();
        RestResponseModel responseModel = methodSignature.getResponseModel();
        TypeElement parameterType = requestModel.getRequiredRequestType();
        RestObjectModelClass modelClass = storage.getModelClass(parameterType.asType().toString()).orElseThrow();
        Map<String, Object> templateArguments = this.createTemplateArguments(staticHeaders, staticQueryParameters, methodSignature);
        templateArguments.put("HAS_MODEL_HEADERS", modelClass.isHeadersPresent());
        this.customizeTemplateArguments(templateArguments, modelClass, parameterType);
        templateArguments.put("VALIDATE_REQUEST_MODE", this.getRequestValidationMode(methodSignature, environmentContext));
        templateArguments.put("MODEL", requestModel.getRequiredVariableName());
        templateArguments.put("EXTRACTOR", GeneratedClassNames.getModelTransformerInstanceName((TypeElement)parameterType, RequestModelExtractor.class));
        this.addValidators(environmentContext, storage, classHeaderBuilder, parameterType, responseModel, templateArguments);
        this.addPathBuilder(methodSignature, templateArguments);
        boolean isRequestClassVirtual = Elements.isVirtualTypeElement((TypeElement)requestModel.getRequiredRequestType());
        templateArguments.put("IS_REQUEST_CLASS_VIRTUAL", isRequestClassVirtual);
        if (isRequestClassVirtual) {
            templateArguments.put("REQUEST_VIRTUAL_CLASS", requestModel.getRequiredRequestType().getSimpleName().toString());
            templateArguments.put("VIRTUAL_FIELDS", ((VirtualTypeElement)requestModel.getRequiredRequestType()).getVirtualFieldElements());
        }
        return new RestClientMethodBody(this.methodBodyGenerator.generate(this.getTemplateName(), templateArguments));
    }

    protected abstract void validate(RestClientMethodSignature var1, StaticQueryParameters var2);

    protected abstract void customizeClassHeaderBuilder(ClassHeader.Builder var1);

    protected abstract void customizeTemplateArguments(Map<String, Object> var1, RestObjectModelClass var2, TypeElement var3);
}

