/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.rest.client.component.impl;

import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.component.ModuleGeneratorConfigBuilder;
import io.rxmicro.annotation.processor.common.model.EnvironmentContext;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.common.util.Annotations;
import io.rxmicro.annotation.processor.rest.client.model.RestClientModuleGeneratorConfig;
import io.rxmicro.rest.client.RestClientGeneratorConfig;
import io.rxmicro.rest.model.ClientExchangeFormatModule;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.Element;

@Singleton
public final class RestClientModuleGeneratorConfigBuilder
implements ModuleGeneratorConfigBuilder<RestClientModuleGeneratorConfig> {
    public RestClientModuleGeneratorConfig build(EnvironmentContext environmentContext) {
        RestClientGeneratorConfig config = (RestClientGeneratorConfig)Annotations.getPresentOrDefaultAnnotation((AnnotatedConstruct)environmentContext.getCurrentModule(), RestClientGeneratorConfig.class);
        ClientExchangeFormatModule exchangeFormat = this.getExchangeFormat(environmentContext, config);
        return new RestClientModuleGeneratorConfig(environmentContext, exchangeFormat, config);
    }

    private ClientExchangeFormatModule getExchangeFormat(EnvironmentContext environmentContext, RestClientGeneratorConfig config) {
        ClientExchangeFormatModule exchangeFormat = config.exchangeFormat();
        if (exchangeFormat == ClientExchangeFormatModule.AUTO_DETECT) {
            return this.detectExchangeFormatAuto(environmentContext, exchangeFormat);
        }
        return exchangeFormat;
    }

    private ClientExchangeFormatModule detectExchangeFormatAuto(EnvironmentContext environmentContext, ClientExchangeFormatModule exchangeFormat) {
        ClientExchangeFormatModule clientExchangeFormatModule = null;
        for (ClientExchangeFormatModule exchangeFormatModule : exchangeFormat.allExchangeFormatModules()) {
            if (!environmentContext.getRxMicroModules().contains(exchangeFormatModule.getRxMicroModule())) continue;
            if (clientExchangeFormatModule != null) {
                throw new InterruptProcessingException((Element)environmentContext.getCurrentModule(), "Specify exchangeFormat for all REST clients!", new Object[0]);
            }
            clientExchangeFormatModule = exchangeFormatModule;
        }
        if (clientExchangeFormatModule == null) {
            throw new InterruptProcessingException((Element)environmentContext.getCurrentModule(), "Missing exchange format rxmicro module. Add 'requires rxmicro.rest.client.exchange.json;' to 'module-info.java'", new Object[0]);
        }
        return clientExchangeFormatModule;
    }
}

