/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.rest.client.component.impl;

import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.model.ModelField;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.common.model.method.MethodResult;
import io.rxmicro.annotation.processor.rest.client.component.RestClientModelReaderBuilder;
import io.rxmicro.annotation.processor.rest.client.model.ModelReaderClassStructure;
import io.rxmicro.annotation.processor.rest.client.model.ModelReaderType;
import io.rxmicro.annotation.processor.rest.client.model.RestClientClassSignature;
import io.rxmicro.annotation.processor.rest.client.model.RestClientMethodSignature;
import io.rxmicro.annotation.processor.rest.model.MappedRestObjectModelClass;
import io.rxmicro.annotation.processor.rest.model.RestObjectModelClass;
import io.rxmicro.rest.Header;
import io.rxmicro.rest.model.ExchangeFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;

@Singleton
public final class RestClientModelReaderBuilderImpl
implements RestClientModelReaderBuilder {
    @Override
    public Set<ModelReaderClassStructure> build(List<MappedRestObjectModelClass> mappedRestObjectModelClasses, Set<RestClientClassSignature> classSignatures, ExchangeFormat exchangeFormat) {
        return mappedRestObjectModelClasses.stream().map(restModelClass -> new ModelReaderClassStructure(restModelClass.getModelClass(), exchangeFormat, this.getModelReaderType((MappedRestObjectModelClass)restModelClass, classSignatures))).collect(Collectors.toSet());
    }

    private ModelReaderType getModelReaderType(MappedRestObjectModelClass restModelClass, Set<RestClientClassSignature> classSignatures) {
        String type = restModelClass.getModelClass().getJavaFullClassName();
        HashSet modelReaders = new HashSet();
        for (RestClientClassSignature classSignature : classSignatures) {
            for (RestClientMethodSignature methodSignature : classSignature.getMethodSignatures()) {
                methodSignature.getResponseModel().getMethodResult().ifPresent(methodResult -> {
                    if (methodResult.getResultType().toString().equals(type)) {
                        this.validate(methodSignature.getMethod(), (MethodResult)methodResult, restModelClass.getModelClass());
                        modelReaders.add(methodResult.isOneItem() ? ModelReaderType.SINGLE : ModelReaderType.LIST);
                    }
                });
            }
        }
        return modelReaders.size() == 2 ? ModelReaderType.BOTH : (ModelReaderType)((Object)modelReaders.iterator().next());
    }

    private void validate(ExecutableElement restClientMethod, MethodResult methodResult, RestObjectModelClass modelClass) {
        if (!methodResult.isOneItem()) {
            if (modelClass.isInternalsPresent()) {
                throw new InterruptProcessingException((Element)restClientMethod, "'?' model class couldn't contain internal fields: [?], because rest client method returns a list of items. Remove internal types or change method result type!", new Object[]{modelClass.getJavaFullClassName(), modelClass.getInternals().stream().map(ModelField::getFieldName).collect(Collectors.joining(","))});
            }
            if (modelClass.isHeadersPresent()) {
                throw new InterruptProcessingException((Element)restClientMethod, "'?' model class couldn't contain fields annotated by '@?' annotation, because rest client method returns a list of items. Remove headers or change method result type!", new Object[]{modelClass.getJavaFullClassName(), Header.class.getName()});
            }
        }
    }
}

