/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.rest.client.component.impl;

import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.model.AnnotatedModelElement;
import io.rxmicro.annotation.processor.common.model.ModelFieldBuilderOptions;
import io.rxmicro.annotation.processor.common.model.ModelFieldType;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.common.util.Elements;
import io.rxmicro.annotation.processor.common.util.validators.AnnotationValidators;
import io.rxmicro.annotation.processor.rest.client.model.RestClientObjectModelClass;
import io.rxmicro.annotation.processor.rest.component.AbstractRestModelFieldBuilder;
import io.rxmicro.annotation.processor.rest.model.InternalType;
import io.rxmicro.annotation.processor.rest.model.RestModelField;
import io.rxmicro.http.HttpHeaders;
import io.rxmicro.http.HttpVersion;
import io.rxmicro.rest.Header;
import io.rxmicro.rest.Parameter;
import io.rxmicro.rest.PathVariable;
import io.rxmicro.rest.RequestId;
import io.rxmicro.rest.ResponseBody;
import io.rxmicro.rest.ResponseStatusCode;
import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

@Singleton
public final class RestClientModelFieldBuilderImpl
extends AbstractRestModelFieldBuilder {
    protected RestClientObjectModelClass createObjectModelClass(ModuleElement currentModule, ModelFieldType modelFieldType, TypeMirror type, TypeElement typeElement, int nestedLevel, ModelFieldBuilderOptions options) {
        return new RestClientObjectModelClass(type, typeElement, this.getFieldMap(currentModule, modelFieldType, (TypeElement)Elements.asTypeElement((TypeMirror)type).orElseThrow(), nestedLevel, options), null, true);
    }

    protected Optional<RestModelField> buildInternal(ModelFieldType modelFieldType, AnnotatedModelElement annotated) {
        if (HttpVersion.class.getName().equals(annotated.getField().asType().toString())) {
            this.validateInternalByType(modelFieldType, annotated);
            return Optional.of(new RestModelField(annotated, InternalType.HTTP_VERSION));
        }
        if (HttpHeaders.class.getName().equals(annotated.getField().asType().toString())) {
            this.validateInternalByType(modelFieldType, annotated);
            return Optional.of(new RestModelField(annotated, InternalType.HTTP_HEADERS));
        }
        ResponseStatusCode responseStatusCode = (ResponseStatusCode)annotated.getAnnotation(ResponseStatusCode.class);
        if (responseStatusCode != null) {
            this.validateInternalByAnnotation(modelFieldType, annotated, ResponseStatusCode.class);
            AnnotationValidators.validateSupportedTypes((Element)annotated.getField(), (Class)responseStatusCode.annotationType());
            return Optional.of(new RestModelField(annotated, InternalType.RESPONSE_STATUS));
        }
        ResponseBody responseBody = (ResponseBody)annotated.getAnnotation(ResponseBody.class);
        if (responseBody != null) {
            this.validateInternalByAnnotation(modelFieldType, annotated, ResponseBody.class);
            AnnotationValidators.validateSupportedTypes((Element)annotated.getField(), (Class)responseBody.annotationType());
            return Optional.of(new RestModelField(annotated, InternalType.RESPONSE_BODY));
        }
        return Optional.empty();
    }

    protected Set<Class<? extends Annotation>> supportedRequestAnnotations() {
        return Set.of(Header.class, Parameter.class, PathVariable.class, RequestId.class);
    }

    protected Set<Class<? extends Annotation>> supportedResponseAnnotations() {
        return Set.of(Header.class, Parameter.class, ResponseBody.class, ResponseStatusCode.class);
    }

    private void validateInternalByType(ModelFieldType modelFieldType, AnnotatedModelElement annotated) {
        this.validateNoAnnotations(annotated);
        if (modelFieldType != ModelFieldType.REST_CLIENT_RESPONSE) {
            throw new InterruptProcessingException((Element)annotated.getField(), "'?' type can be used for response model only", new Object[]{annotated.getField().asType().toString()});
        }
    }

    private void validateInternalByAnnotation(ModelFieldType modelFieldType, AnnotatedModelElement annotated, Class<? extends Annotation> annotationClass) {
        if (modelFieldType != ModelFieldType.REST_CLIENT_RESPONSE) {
            throw new InterruptProcessingException((Element)annotated.getField(), "'?' annotation can be used for response model only", new Object[]{annotationClass.getName()});
        }
    }
}

