/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.rest.client.component.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.model.SupportedAnnotations;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.common.util.Elements;
import io.rxmicro.annotation.processor.common.util.validators.AnnotationValidators;
import io.rxmicro.annotation.processor.rest.client.component.RestClientMethodSignatureBuilder;
import io.rxmicro.annotation.processor.rest.client.model.RestClientMethodSignature;
import io.rxmicro.annotation.processor.rest.component.HttpMethodMappingBuilder;
import io.rxmicro.annotation.processor.rest.component.RestRequestModelBuilder;
import io.rxmicro.annotation.processor.rest.component.RestResponseModelBuilder;
import io.rxmicro.annotation.processor.rest.component.impl.AbstractRestMethodSignatureBuilder;
import io.rxmicro.annotation.processor.rest.model.ParentUrl;
import io.rxmicro.annotation.processor.rest.model.RestResponseModel;
import io.rxmicro.common.util.ExCollections;
import io.rxmicro.rest.AddHeader;
import io.rxmicro.rest.AddQueryParameter;
import io.rxmicro.rest.HeaderMappingStrategy;
import io.rxmicro.rest.ParameterMappingStrategy;
import io.rxmicro.rest.SetHeader;
import io.rxmicro.rest.SetQueryParameter;
import io.rxmicro.rest.method.DELETE;
import io.rxmicro.rest.method.GET;
import io.rxmicro.rest.method.HEAD;
import io.rxmicro.rest.method.OPTIONS;
import io.rxmicro.rest.method.PATCH;
import io.rxmicro.rest.method.POST;
import io.rxmicro.rest.method.PUT;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

@Singleton
public final class RestClientMethodSignatureBuilderImpl
extends AbstractRestMethodSignatureBuilder
implements RestClientMethodSignatureBuilder {
    @Inject
    private RestRequestModelBuilder restRequestModelBuilder;
    @Inject
    private RestResponseModelBuilder restResponseModelBuilder;
    @Inject
    private HttpMethodMappingBuilder httpMethodMappingBuilder;

    @Override
    public List<RestClientMethodSignature> build(ModuleElement restControllerModule, TypeElement restClientInterface, ParentUrl parentUrl, Map.Entry<TypeElement, List<ExecutableElement>> overriddenMethodCandidates) {
        List methods = Elements.allImplementableMethods((TypeElement)restClientInterface);
        this.validateMethods(methods, overriddenMethodCandidates.getValue());
        return methods.stream().filter(e -> this.notContainIn((ExecutableElement)e, (List)overriddenMethodCandidates.getValue())).map(method -> {
            RestResponseModel responseModel = this.restResponseModelBuilder.build(restControllerModule, method, true);
            this.validateReturnType((ExecutableElement)method, responseModel);
            return new RestClientMethodSignature((ExecutableElement)method, this.restRequestModelBuilder.build(restControllerModule, method, false), responseModel, this.httpMethodMappingBuilder.buildSingle(parentUrl, method));
        }).collect(Collectors.toList());
    }

    private void validateMethods(List<ExecutableElement> methods, List<ExecutableElement> overriddenMethods) {
        for (ExecutableElement method : methods) {
            List<? extends AnnotationMirror> annotations = method.getAnnotationMirrors();
            AnnotationValidators.validateOnlyOneAnnotationPerElement((Element)method, annotations, (SupportedAnnotations)this.getHttpMethodAnnotations());
            AnnotationValidators.validateRedundantAnnotationsPerElement((Element)method, annotations, (SupportedAnnotations)this.getSupportedAnnotations(), (String)"Rest client method");
            annotations.stream().filter(annotation -> this.getHttpMethodAnnotations().isAnnotationSupported(annotation.getAnnotationType())).findFirst().ifPresent(annotation -> this.validateAnnotatedInterfaceMethodModifiers(method, (AnnotationMirror)annotation));
            if (!overriddenMethods.stream().anyMatch(otherMethod -> Elements.methodSignatureEquals((ExecutableElement)method, (ExecutableElement)otherMethod))) continue;
            AnnotationValidators.validateNoRxMicroAnnotationsPerElement((Element)method, (String)"current method is already implemented");
        }
    }

    private void validateReturnType(ExecutableElement method, RestResponseModel responseModel) {
        if (responseModel.isVoidReturn()) {
            throw new InterruptProcessingException((Element)method, "'void' return type not allowed: Use CompletableFuture<Void>, Mono<Void>, etc instead", new Object[0]);
        }
        if (responseModel.isOptional()) {
            TypeMirror typeMirror = (TypeMirror)responseModel.getReactiveType().orElseThrow();
            throw new InterruptProcessingException((Element)method, "Optional not allowed here. So replace ?<Optional<TYPE>> by ?<TYPE>", new Object[]{typeMirror, typeMirror});
        }
    }

    protected Set<Class<? extends Annotation>> getSupportedAnnotationsPerMethod() {
        return ExCollections.unmodifiableOrderedSet(Arrays.asList(GET.class, POST.class, PUT.class, DELETE.class, PATCH.class, OPTIONS.class, HEAD.class, HeaderMappingStrategy.class, ParameterMappingStrategy.class, AddHeader.class, SetHeader.class, AddQueryParameter.class, SetQueryParameter.class));
    }
}

