/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.rest.client.component.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.model.ClassHeader;
import io.rxmicro.annotation.processor.common.model.EnvironmentContext;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.common.model.method.MethodBody;
import io.rxmicro.annotation.processor.rest.client.component.ClientCommonOptionBuilder;
import io.rxmicro.annotation.processor.rest.client.component.RestClientMethodBodyBuilder;
import io.rxmicro.annotation.processor.rest.client.component.RestClientMethodBuilder;
import io.rxmicro.annotation.processor.rest.client.model.RestClientClassStructureStorage;
import io.rxmicro.annotation.processor.rest.client.model.RestClientMethod;
import io.rxmicro.annotation.processor.rest.client.model.RestClientMethodSignature;
import io.rxmicro.annotation.processor.rest.model.StaticHeaders;
import io.rxmicro.annotation.processor.rest.model.StaticQueryParameters;
import io.rxmicro.common.util.ExCollections;
import io.rxmicro.http.local.RepeatableValues;
import io.rxmicro.rest.client.detail.ErrorResponseCheckerHelper;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;

@Singleton
public final class RestClientMethodBuilderImpl
implements RestClientMethodBuilder {
    @Inject
    private Set<RestClientMethodBodyBuilder> restClientMethodBodyBuilders;
    @Inject
    private ClientCommonOptionBuilder clientCommonOptionBuilder;

    @Override
    public RestClientMethod build(EnvironmentContext environmentContext, RestClientClassStructureStorage restClientClassStructureStorage, ClassHeader.Builder classHeaderBuilder, StaticHeaders staticHeaders, StaticQueryParameters staticQueryParameters, RestClientMethodSignature methodSignature, TypeElement configClass) {
        RestClientMethodBodyBuilder methodBodyBuilder = this.getMethodBodyBuilder(methodSignature);
        methodSignature.getRequestModel().getRequestType().ifPresent(xva$0 -> classHeaderBuilder.addImports(new TypeElement[]{xva$0}));
        classHeaderBuilder.addImports(methodSignature.getResponseModel().getRequiredImports().toArray(ExCollections.EMPTY_STRING_ARRAY)).addStaticImport(ErrorResponseCheckerHelper.class, "throwExceptionIfNotSuccess");
        MethodBody methodBody = methodBodyBuilder.build(environmentContext, restClientClassStructureStorage, classHeaderBuilder, this.getStaticHeaders(staticHeaders, classHeaderBuilder, methodSignature.getMethod(), configClass), this.getStaticQueryParameters(staticQueryParameters, classHeaderBuilder, methodSignature.getMethod(), configClass), methodSignature);
        return new RestClientMethod(methodSignature.getMethod(), methodSignature.getSimpleName(), methodSignature.getRequestModel(), methodBody, methodSignature.getResponseModel());
    }

    private StaticHeaders getStaticHeaders(StaticHeaders staticHeaders, ClassHeader.Builder classHeaderBuilder, ExecutableElement restClientMethod, TypeElement configClass) {
        StaticHeaders result = new StaticHeaders(staticHeaders);
        result.setOrAddAll((RepeatableValues)this.clientCommonOptionBuilder.getStaticHeaders(classHeaderBuilder, restClientMethod, configClass));
        return result;
    }

    private StaticQueryParameters getStaticQueryParameters(StaticQueryParameters staticQueryParameters, ClassHeader.Builder classHeaderBuilder, ExecutableElement restClientMethod, TypeElement configClass) {
        StaticQueryParameters result = new StaticQueryParameters(staticQueryParameters);
        result.setOrAddAll((RepeatableValues)this.clientCommonOptionBuilder.getStaticQueryParameters(classHeaderBuilder, restClientMethod, configClass));
        return result;
    }

    private RestClientMethodBodyBuilder getMethodBodyBuilder(RestClientMethodSignature methodSignature) {
        Set methodBuilders = this.restClientMethodBodyBuilders.stream().filter(methodBuilder -> methodBuilder.isSupported(methodSignature)).collect(Collectors.toSet());
        if (methodBuilders.isEmpty()) {
            throw new InterruptProcessingException((Element)methodSignature.getMethod(), "The RxMicro framework does not know how to generate a body of this method.", new Object[0]);
        }
        if (methodBuilders.size() > 1) {
            throw new InterruptProcessingException((Element)methodSignature.getMethod(), "Rest client method has ambiguous definitions: ?", new Object[]{methodBuilders});
        }
        return (RestClientMethodBodyBuilder)methodBuilders.iterator().next();
    }
}

