/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.rest.client.component.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.component.impl.BaseProcessorComponent;
import io.rxmicro.annotation.processor.common.model.ClassHeader;
import io.rxmicro.annotation.processor.common.model.EnvironmentContext;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.common.util.Annotations;
import io.rxmicro.annotation.processor.common.util.Names;
import io.rxmicro.annotation.processor.rest.client.component.ClientCommonOptionBuilder;
import io.rxmicro.annotation.processor.rest.client.component.RestClientClassStructureBuilder;
import io.rxmicro.annotation.processor.rest.client.component.RestClientMethodBuilder;
import io.rxmicro.annotation.processor.rest.client.model.RestClientClassSignature;
import io.rxmicro.annotation.processor.rest.client.model.RestClientClassStructure;
import io.rxmicro.annotation.processor.rest.client.model.RestClientClassStructureStorage;
import io.rxmicro.annotation.processor.rest.client.model.RestClientMethod;
import io.rxmicro.annotation.processor.rest.client.model.RestClientMethodSignature;
import io.rxmicro.annotation.processor.rest.model.ParentUrl;
import io.rxmicro.annotation.processor.rest.model.StaticHeaders;
import io.rxmicro.annotation.processor.rest.model.StaticQueryParameters;
import io.rxmicro.common.util.Formats;
import io.rxmicro.config.Config;
import io.rxmicro.rest.client.RestClient;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

@Singleton
public final class RestClientClassStructureBuilderImpl
extends BaseProcessorComponent
implements RestClientClassStructureBuilder {
    @Inject
    private RestClientMethodBuilder restClientMethodBuilder;
    @Inject
    private ClientCommonOptionBuilder clientCommonOptionBuilder;

    @Override
    public Set<RestClientClassStructure> build(EnvironmentContext environmentContext, RestClientClassStructureStorage restClientClassStructureStorage, Set<RestClientClassSignature> classSignatures) {
        return classSignatures.stream().map(signature -> this.build(environmentContext, restClientClassStructureStorage, (RestClientClassSignature)((Object)signature))).collect(Collectors.toSet());
    }

    private RestClientClassStructure build(EnvironmentContext environmentContext, RestClientClassStructureStorage restClientClassStructureStorage, RestClientClassSignature signature) {
        TypeElement restClientInterface = signature.getRestClientInterface();
        ClassHeader.Builder classHeaderBuilder = ClassHeader.newClassHeaderBuilder((String)Names.getPackageName((TypeMirror)restClientInterface.asType()));
        RestClient restClientAnnotation = restClientInterface.getAnnotation(RestClient.class);
        TypeElement configClass = Annotations.getRequiredAnnotationClassParameter(() -> ((RestClient)restClientAnnotation).configClass());
        StaticHeaders staticHeaders = this.getCommonHeaders(signature, restClientInterface, classHeaderBuilder, configClass);
        StaticQueryParameters staticQueryParameters = this.clientCommonOptionBuilder.getStaticQueryParameters(classHeaderBuilder, restClientInterface, configClass);
        AtomicInteger count = new AtomicInteger(0);
        List<RestClientMethod> methods = this.buildMethods(environmentContext, restClientClassStructureStorage, classHeaderBuilder, staticHeaders, staticQueryParameters, signature, configClass, count);
        if (count.get() != methods.size()) {
            throw new InterruptProcessingException((Element)restClientInterface, "Rest client implementation couldn't be generated because some methods have errors. Fix these errors and compile again.", new Object[0]);
        }
        String configNameSpace = restClientAnnotation.configNameSpace();
        String restClientConfigNameSpace = configNameSpace.isBlank() ? Config.getDefaultNameSpace((String)Names.getSimpleName((TypeElement)configClass)) : configNameSpace;
        List defaultConfigValues = Annotations.getValidatedDefaultConfigValues((String)restClientConfigNameSpace, (TypeElement)configClass, (Element)restClientInterface);
        return new RestClientClassStructure(classHeaderBuilder, restClientConfigNameSpace, defaultConfigValues, configClass, restClientInterface, signature.getRestClientAbstractClass(), methods, restClientClassStructureStorage);
    }

    private StaticHeaders getCommonHeaders(RestClientClassSignature signature, TypeElement restClientInterface, ClassHeader.Builder classHeaderBuilder, TypeElement configClass) {
        ParentUrl parentUrl = signature.getParentUrl();
        if (parentUrl.isHeaderVersionStrategy()) {
            StaticHeaders staticHeaders = this.clientCommonOptionBuilder.getStaticHeaders(classHeaderBuilder, restClientInterface, configClass);
            if (!staticHeaders.contains(parentUrl.getVersionHeaderName())) {
                staticHeaders.set(parentUrl.getVersionHeaderName(), Formats.format((String)"\"?\"", (Object[])new Object[]{parentUrl.getVersionValue()}));
            }
            return staticHeaders;
        }
        return this.clientCommonOptionBuilder.getStaticHeaders(classHeaderBuilder, restClientInterface, configClass);
    }

    private List<RestClientMethod> buildMethods(EnvironmentContext environmentContext, RestClientClassStructureStorage restClientClassStructureStorage, ClassHeader.Builder classHeaderBuilder, StaticHeaders staticHeaders, StaticQueryParameters staticQueryParameters, RestClientClassSignature signature, TypeElement configClass, AtomicInteger count) {
        ArrayList<RestClientMethod> methods = new ArrayList<RestClientMethod>();
        signature.getMethodSignatures().forEach(methodSignature -> {
            try {
                count.incrementAndGet();
                methods.add(this.restClientMethodBuilder.build(environmentContext, restClientClassStructureStorage, classHeaderBuilder, staticHeaders, staticQueryParameters, (RestClientMethodSignature)methodSignature, configClass));
            }
            catch (InterruptProcessingException ex) {
                this.error(ex);
            }
        });
        return methods;
    }
}

