/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.rest.client.component.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.component.impl.AbstractPartialImplementationBuilder;
import io.rxmicro.annotation.processor.common.model.EnvironmentContext;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.rest.client.component.RestClientClassSignatureBuilder;
import io.rxmicro.annotation.processor.rest.client.component.RestClientMethodSignatureBuilder;
import io.rxmicro.annotation.processor.rest.client.model.RestClientClassSignature;
import io.rxmicro.annotation.processor.rest.component.ParentUrlBuilder;
import io.rxmicro.annotation.processor.rest.model.ParentUrl;
import io.rxmicro.rest.client.PartialImplementation;
import io.rxmicro.rest.client.RestClient;
import io.rxmicro.rest.client.detail.AbstractRestClient;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.TypeElement;

@Singleton
public final class RestClientClassSignatureBuilderImpl
extends AbstractPartialImplementationBuilder
implements RestClientClassSignatureBuilder {
    @Inject
    private ParentUrlBuilder parentUrlBuilder;
    @Inject
    private RestClientMethodSignatureBuilder restClientMethodSignatureBuilder;

    @Override
    public Set<RestClientClassSignature> build(EnvironmentContext environmentContext, Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        HashSet<RestClientClassSignature> result = new HashSet<RestClientClassSignature>();
        for (TypeElement typeElement : annotations) {
            for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                this.validateInterfaceType(element, RestClient.class, "Rest client");
                TypeElement restClientInterface = (TypeElement)element;
                if (!environmentContext.isRxMicroClassShouldBeProcessed(restClientInterface)) continue;
                try {
                    result.add(this.build(environmentContext, restClientInterface));
                }
                catch (InterruptProcessingException ex) {
                    this.error(ex);
                }
            }
        }
        return result;
    }

    private RestClientClassSignature build(EnvironmentContext environmentContext, TypeElement restClientInterface) {
        ModuleElement restControllerModule = environmentContext.getCurrentModule();
        ParentUrl parentUrl = this.parentUrlBuilder.build(restClientInterface);
        Map.Entry methodCandidates = this.getOverriddenMethodCandidates(restClientInterface);
        return new RestClientClassSignature(parentUrl, restClientInterface, (TypeElement)methodCandidates.getKey(), this.restClientMethodSignatureBuilder.build(restControllerModule, restClientInterface, parentUrl, methodCandidates));
    }

    protected Class<? extends Annotation> getPartialImplementationAnnotationClass() {
        return PartialImplementation.class;
    }

    protected Class<?> getDefaultAbstractClass() {
        return AbstractRestClient.class;
    }
}

