/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.rest.client.component.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.component.ExpressionBuilder;
import io.rxmicro.annotation.processor.common.component.ExpressionParser;
import io.rxmicro.annotation.processor.common.model.ClassHeader;
import io.rxmicro.annotation.processor.common.model.Expression;
import io.rxmicro.annotation.processor.rest.client.component.ClientCommonOptionBuilder;
import io.rxmicro.annotation.processor.rest.model.StaticHeaders;
import io.rxmicro.annotation.processor.rest.model.StaticQueryParameters;
import io.rxmicro.common.util.Formats;
import io.rxmicro.rest.AddHeader;
import io.rxmicro.rest.AddQueryParameter;
import io.rxmicro.rest.SetHeader;
import io.rxmicro.rest.SetQueryParameter;
import java.util.Arrays;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

@Singleton
public final class ClientCommonOptionBuilderImpl
implements ClientCommonOptionBuilder {
    @Inject
    private ExpressionParser expressionParser;
    @Inject
    private ExpressionBuilder expressionBuilder;

    @Override
    public StaticHeaders getStaticHeaders(ClassHeader.Builder classHeaderBuilder, Element element, TypeElement configClass) {
        StaticHeaders staticHeaders = new StaticHeaders();
        Arrays.stream((AddHeader[])element.getAnnotationsByType(AddHeader.class)).forEach(a -> staticHeaders.add(a.name(), this.resolveExpression(classHeaderBuilder, element, configClass, a.value())));
        Arrays.stream((SetHeader[])element.getAnnotationsByType(SetHeader.class)).forEach(a -> staticHeaders.set(a.name(), this.resolveExpression(classHeaderBuilder, element, configClass, a.value())));
        return staticHeaders;
    }

    @Override
    public StaticQueryParameters getStaticQueryParameters(ClassHeader.Builder classHeaderBuilder, Element element, TypeElement configClass) {
        StaticQueryParameters staticQueryParameters = new StaticQueryParameters();
        Arrays.stream((AddQueryParameter[])element.getAnnotationsByType(AddQueryParameter.class)).forEach(a -> staticQueryParameters.add(a.name(), this.resolveExpression(classHeaderBuilder, element, configClass, a.value())));
        Arrays.stream((SetQueryParameter[])element.getAnnotationsByType(SetQueryParameter.class)).forEach(a -> staticQueryParameters.set(a.name(), this.resolveExpression(classHeaderBuilder, element, configClass, a.value())));
        return staticQueryParameters;
    }

    private String resolveExpression(ClassHeader.Builder classHeaderBuilder, Element owner, TypeElement configClass, String value) {
        if (value.contains("${")) {
            Expression expression = this.expressionParser.parse(owner, configClass, value);
            return this.expressionBuilder.build(classHeaderBuilder, expression, configClass, "config");
        }
        return Formats.format((String)"\"?\"", (Object[])new Object[]{value});
    }
}

