/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.rest.client.component.impl;

import com.google.inject.Inject;
import io.rxmicro.annotation.processor.common.component.MethodBodyGenerator;
import io.rxmicro.annotation.processor.common.model.ClassHeader;
import io.rxmicro.annotation.processor.common.model.EnvironmentContext;
import io.rxmicro.annotation.processor.common.util.Annotations;
import io.rxmicro.annotation.processor.common.util.GeneratedClassNames;
import io.rxmicro.annotation.processor.common.util.Names;
import io.rxmicro.annotation.processor.rest.client.component.RestClientMethodBodyBuilder;
import io.rxmicro.annotation.processor.rest.client.model.RestClientClassStructureStorage;
import io.rxmicro.annotation.processor.rest.client.model.RestClientMethodSignature;
import io.rxmicro.annotation.processor.rest.client.model.RestClientModuleGeneratorConfig;
import io.rxmicro.annotation.processor.rest.client.model.RestClientSimpleObjectModelClass;
import io.rxmicro.annotation.processor.rest.component.PathVariableValidator;
import io.rxmicro.annotation.processor.rest.model.RestResponseModel;
import io.rxmicro.annotation.processor.rest.model.StaticHeaders;
import io.rxmicro.annotation.processor.rest.model.StaticQueryParameters;
import io.rxmicro.http.error.ValidationException;
import io.rxmicro.rest.client.RestClientGeneratorConfig;
import io.rxmicro.rest.client.detail.ModelReader;
import io.rxmicro.rest.client.detail.PathBuilder;
import io.rxmicro.rest.model.UrlSegments;
import io.rxmicro.tool.common.OverrideGeneratorConfig;
import io.rxmicro.validation.detail.ResponseValidators;
import java.util.HashMap;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

public abstract class BaseRestClientMethodBodyBuilder
implements RestClientMethodBodyBuilder {
    @Inject
    protected MethodBodyGenerator methodBodyGenerator;
    @Inject
    private PathVariableValidator pathVariableValidator;

    protected final Map<String, Object> createTemplateArguments(StaticHeaders staticHeaders, StaticQueryParameters staticQueryParameters, RestClientMethodSignature methodSignature) {
        RestResponseModel responseModel = methodSignature.getResponseModel();
        HashMap<String, Object> templateArguments = new HashMap<String, Object>();
        templateArguments.put("RETURN", responseModel.getMethodResult().orElseThrow());
        templateArguments.put("HEADERS", staticHeaders.getEntries());
        templateArguments.put("QUERY_PARAMS", staticQueryParameters.getEntries());
        templateArguments.put("HTTP_METHOD", methodSignature.getHttpMethodMapping().getMethod());
        templateArguments.put("PATH", methodSignature.getHttpMethodMapping().getUri());
        if (!responseModel.isReactiveVoid()) {
            TypeElement resultType = (TypeElement)responseModel.getResultType().orElseThrow();
            templateArguments.put("RESPONSE_READER", GeneratedClassNames.getModelTransformerInstanceName((String)Names.getSimpleName((TypeElement)resultType), ModelReader.class));
            templateArguments.put("RESPONSE_MODEL_CLASS", (Object)new RestClientSimpleObjectModelClass(resultType));
        }
        return templateArguments;
    }

    protected final void addPathBuilder(RestClientMethodSignature methodSignature, Map<String, Object> templateArguments) {
        TypeElement type = methodSignature.getRequestModel().getRequiredRequestType();
        if (methodSignature.getHttpMethodMapping().isUrlSegmentsPresent()) {
            UrlSegments urlSegments = methodSignature.getHttpMethodMapping().getUrlSegments();
            this.pathVariableValidator.validateThatPathVariablesNotMissingOrRedundant((Element)methodSignature.getMethod(), methodSignature.getHttpMethodMapping(), urlSegments, type);
            templateArguments.put("URL_TEMPLATE", urlSegments.getUrlTemplate());
            templateArguments.put("URL_TEMPLATE_KEY", urlSegments.getOriginalUrl());
            templateArguments.put("PATH_BUILDER", GeneratedClassNames.getModelTransformerInstanceName((TypeElement)type, PathBuilder.class));
        } else {
            this.pathVariableValidator.validateThatPathVariablesNotFound((Element)methodSignature.getMethod(), methodSignature.getHttpMethodMapping(), type);
        }
    }

    protected final void addValidators(EnvironmentContext environmentContext, RestClientClassStructureStorage storage, ClassHeader.Builder classHeaderBuilder, TypeElement parameterType, RestResponseModel methodResult, Map<String, Object> templateArguments) {
        boolean generateResponseValidators;
        RestClientModuleGeneratorConfig config = (RestClientModuleGeneratorConfig)environmentContext.get(RestClientModuleGeneratorConfig.class);
        boolean generateRequestValidators = config.isGenerateRequestValidators() && storage.isRequestValidatorPresent(parameterType.asType().toString());
        templateArguments.put("GENERATE_REQUEST_VALIDATORS", generateRequestValidators);
        if (generateRequestValidators) {
            templateArguments.put("REQUEST_MODEL_CLASS", (Object)new RestClientSimpleObjectModelClass(parameterType));
            classHeaderBuilder.addImports(new Class[]{ValidationException.class});
        }
        boolean bl = generateResponseValidators = config.isGenerateResponseValidators() && !methodResult.isReactiveVoid() && methodResult.getResultType().isPresent() && storage.isResponseValidatorPresent(((TypeElement)methodResult.getResultType().orElseThrow()).asType().toString());
        if (generateResponseValidators) {
            if (methodResult.isFuture()) {
                classHeaderBuilder.addStaticImport(ResponseValidators.class, "validateIfResponseExists");
            } else {
                classHeaderBuilder.addStaticImport(ResponseValidators.class, "validateResponse");
            }
        }
        templateArguments.put("GENERATE_RESPONSE_VALIDATORS", generateResponseValidators);
    }

    protected final RestClientGeneratorConfig.RequestValidationMode getRequestValidationMode(RestClientMethodSignature methodSignature, EnvironmentContext environmentContext) {
        OverrideGeneratorConfig[] overrideGeneratorConfigs;
        for (OverrideGeneratorConfig overrideGeneratorConfig : overrideGeneratorConfigs = (OverrideGeneratorConfig[])methodSignature.getRestClientClassSignature().getRestClientInterface().getAnnotationsByType(OverrideGeneratorConfig.class)) {
            if (!RestClientGeneratorConfig.class.getName().equals(Annotations.getRequiredAnnotationClassParameter(() -> ((OverrideGeneratorConfig)overrideGeneratorConfig).annotationConfigClass()).getQualifiedName().toString()) || !"requestValidationMode".equals(overrideGeneratorConfig.parameterName())) continue;
            return RestClientGeneratorConfig.RequestValidationMode.valueOf((String)overrideGeneratorConfig.overriddenValue());
        }
        return ((RestClientModuleGeneratorConfig)environmentContext.get(RestClientModuleGeneratorConfig.class)).getRequestValidationMode();
    }
}

