/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.rest.client;

import com.google.inject.Inject;
import com.google.inject.Module;
import io.rxmicro.annotation.processor.common.CommonDependenciesModule;
import io.rxmicro.annotation.processor.common.FormatSourceCodeDependenciesModule;
import io.rxmicro.annotation.processor.common.component.ModuleGeneratorConfigBuilder;
import io.rxmicro.annotation.processor.common.component.impl.AbstractModuleClassStructuresBuilder;
import io.rxmicro.annotation.processor.common.model.ClassStructure;
import io.rxmicro.annotation.processor.common.model.EnvironmentContext;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingBecauseAFewErrorsFoundException;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.common.util.Elements;
import io.rxmicro.annotation.processor.common.util.Injects;
import io.rxmicro.annotation.processor.common.util.LoggerMessages;
import io.rxmicro.annotation.processor.rest.RestCommonDependenciesModule;
import io.rxmicro.annotation.processor.rest.client.RestClientDependenciesModule;
import io.rxmicro.annotation.processor.rest.client.component.PathBuilderClassStructureBuilder;
import io.rxmicro.annotation.processor.rest.client.component.RequestModelExtractorClassStructureBuilder;
import io.rxmicro.annotation.processor.rest.client.component.RestClientClassSignatureBuilder;
import io.rxmicro.annotation.processor.rest.client.component.RestClientClassStructureBuilder;
import io.rxmicro.annotation.processor.rest.client.component.RestClientModelReaderBuilder;
import io.rxmicro.annotation.processor.rest.client.model.RestClientClassSignature;
import io.rxmicro.annotation.processor.rest.client.model.RestClientClassStructure;
import io.rxmicro.annotation.processor.rest.client.model.RestClientClassStructureStorage;
import io.rxmicro.annotation.processor.rest.client.model.RestClientFactoryClassStructure;
import io.rxmicro.annotation.processor.rest.client.model.RestClientMethodSignature;
import io.rxmicro.annotation.processor.rest.client.model.RestClientModuleGeneratorConfig;
import io.rxmicro.annotation.processor.rest.client.model.RestClientObjectModelClass;
import io.rxmicro.annotation.processor.rest.component.RestGenerationContextBuilder;
import io.rxmicro.annotation.processor.rest.component.RestModelFromJsonConverterBuilder;
import io.rxmicro.annotation.processor.rest.component.RestModelToJsonConverterBuilder;
import io.rxmicro.annotation.processor.rest.component.RestModelValidatorBuilder;
import io.rxmicro.annotation.processor.rest.model.HttpMethodMapping;
import io.rxmicro.annotation.processor.rest.model.MappedRestObjectModelClass;
import io.rxmicro.annotation.processor.rest.model.RestGenerationContext;
import io.rxmicro.annotation.processor.rest.model.RestObjectModelClass;
import io.rxmicro.annotation.processor.rest.model.VirtualTypeClassStructure;
import io.rxmicro.annotation.processor.rest.model.converter.ReaderType;
import io.rxmicro.common.util.Formats;
import io.rxmicro.rest.client.RestClient;
import io.rxmicro.rest.model.ExchangeFormat;
import io.rxmicro.validation.DisableValidation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;

public final class RestClientModuleClassStructuresBuilder
extends AbstractModuleClassStructuresBuilder {
    @Inject
    private ModuleGeneratorConfigBuilder<RestClientModuleGeneratorConfig> restClientModuleGeneratorConfigBuilder;
    @Inject
    private RestClientClassSignatureBuilder restClientClassSignatureBuilder;
    @Inject
    private RestClientClassStructureBuilder restClientClassStructureBuilder;
    @Inject
    private RestGenerationContextBuilder restGenerationContextBuilder;
    @Inject
    private RestClientModelReaderBuilder restClientModelReaderBuilder;
    @Inject
    private RestModelToJsonConverterBuilder restModelToJsonConverterBuilder;
    @Inject
    private RestModelFromJsonConverterBuilder restModelFromJsonConverterBuilder;
    @Inject
    private RequestModelExtractorClassStructureBuilder requestModelExtractorClassStructureBuilder;
    @Inject
    private PathBuilderClassStructureBuilder pathBuilderClassStructureBuilder;
    @Inject
    private RestModelValidatorBuilder restModelValidatorBuilder;

    public static RestClientModuleClassStructuresBuilder create() {
        RestClientModuleClassStructuresBuilder builder = new RestClientModuleClassStructuresBuilder();
        Injects.injectDependencies((Object)((Object)builder), (Module[])new Module[]{new FormatSourceCodeDependenciesModule(), new CommonDependenciesModule(), new RestCommonDependenciesModule(), new RestClientDependenciesModule()});
        return builder;
    }

    private RestClientModuleClassStructuresBuilder() {
    }

    public String getBuilderName() {
        return "rest-client-annotation-processor-module";
    }

    public Set<String> getSupportedAnnotationTypes() {
        return Set.of(RestClient.class.getName());
    }

    public Set<? extends ClassStructure> buildClassStructures(EnvironmentContext environmentContext, Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            Set<RestClientClassSignature> classSignatures = this.restClientClassSignatureBuilder.build(environmentContext, annotations, roundEnv);
            if (!classSignatures.isEmpty()) {
                environmentContext.put(this.restClientModuleGeneratorConfigBuilder.build(environmentContext));
                this.logFoundRestClients(classSignatures);
                RestGenerationContext restGenerationContext = this.restGenerationContextBuilder.build(environmentContext, RestClientModuleGeneratorConfig.class, classSignatures);
                RestClientClassStructureStorage restClientClassStructureStorage = this.buildRestClientClassStructureStorage(environmentContext, classSignatures, restGenerationContext);
                HashSet<ClassStructure> classStructures = new HashSet<ClassStructure>(restClientClassStructureStorage.getAll());
                Set<RestClientClassStructure> restClientClassStructures = this.restClientClassStructureBuilder.build(environmentContext, restClientClassStructureStorage, classSignatures);
                classStructures.addAll(restClientClassStructures);
                classStructures.add(new RestClientFactoryClassStructure(restClientClassStructures, restClientClassStructures.stream().flatMap(c -> c.getDefaultConfigValues().stream()).collect(Collectors.toList())));
                this.addAllVirtualRequestClassStructures(classStructures, classSignatures, restClientClassStructureStorage);
                return classStructures;
            }
            return Set.of();
        }
        catch (InterruptProcessingException ex) {
            this.error(ex);
            return Set.of();
        }
        catch (InterruptProcessingBecauseAFewErrorsFoundException ignore) {
            return Set.of();
        }
    }

    private void addAllVirtualRequestClassStructures(Set<ClassStructure> classStructures, Set<RestClientClassSignature> classSignatures, RestClientClassStructureStorage restClientClassStructureStorage) {
        for (RestClientClassSignature classSignature : classSignatures) {
            for (RestClientMethodSignature methodSignature : classSignature.getMethodSignatures()) {
                methodSignature.getRequestModel().getRequestType().filter(Elements::isVirtualTypeElement).flatMap(t -> restClientClassStructureStorage.getModelClass(t.getQualifiedName().toString())).ifPresent(modelClass -> classStructures.add((ClassStructure)new VirtualTypeClassStructure(modelClass, true)));
            }
        }
    }

    private void logFoundRestClients(Set<RestClientClassSignature> set) {
        if (this.isInfoEnabled()) {
            StringBuilder stringBuilder = new StringBuilder("Found the following REST clients:\n");
            for (RestClientClassSignature signature : set) {
                stringBuilder.append(Formats.format((String)"??:\n", (Object[])new Object[]{"  ", signature.getRestClientInterface().getQualifiedName()}));
                for (RestClientMethodSignature methodSignature : signature.getMethodSignatures()) {
                    for (HttpMethodMapping httpMethodMapping : methodSignature.getHttpMethodMappings()) {
                        stringBuilder.append(Formats.format((String)"??'? ?' -> ?;\n", (Object[])new Object[]{"  ", "  ", httpMethodMapping.getMethod(), httpMethodMapping.getExactOrTemplateUri(), LoggerMessages.getLoggableMethodName((ExecutableElement)methodSignature.getMethod())}));
                    }
                }
            }
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            this.info(stringBuilder.toString(), new Supplier[0]);
        }
    }

    private RestClientClassStructureStorage buildRestClientClassStructureStorage(EnvironmentContext environmentContext, Set<RestClientClassSignature> classSignatures, RestGenerationContext context) {
        ExchangeFormat clientExchangeFormat = ((RestClientModuleGeneratorConfig)environmentContext.get(RestClientModuleGeneratorConfig.class)).getExchangeFormatModule().getExchangeFormat();
        ArrayList<MappedRestObjectModelClass> toHttpQueryModelClasses = new ArrayList<MappedRestObjectModelClass>();
        ArrayList<MappedRestObjectModelClass> toHttpBodyModelClasses = new ArrayList<MappedRestObjectModelClass>();
        ArrayList<MappedRestObjectModelClass> toHttpPathModelClasses = new ArrayList<MappedRestObjectModelClass>();
        this.separateModelClasses(context.getToHttpDataModelClasses(), toHttpQueryModelClasses, toHttpBodyModelClasses, toHttpPathModelClasses);
        RestClientClassStructureStorage.Builder builder = new RestClientClassStructureStorage.Builder().addModelReaders(this.restClientModelReaderBuilder.build(context.getFromHttpDataModelClasses(), classSignatures, clientExchangeFormat)).addModelFromJsonConverters(this.restModelFromJsonConverterBuilder.buildFromJson(context.getFromHttpDataModelClasses(), clientExchangeFormat, true)).addRequestModelExtractors(this.requestModelExtractorClassStructureBuilder.build(toHttpQueryModelClasses)).addPathBuilders(this.pathBuilderClassStructureBuilder.build(toHttpPathModelClasses)).addModelToJsonConverters(this.restModelToJsonConverterBuilder.buildToJson(toHttpBodyModelClasses, clientExchangeFormat, true));
        this.addValidators(environmentContext, context, builder);
        builder.addRestObjectModelClasses(context.getFromHttpDataModelClasses().stream().map(MappedRestObjectModelClass::getModelClass).collect(Collectors.toSet()));
        builder.addRestObjectModelClasses(context.getToHttpDataModelClasses().stream().map(MappedRestObjectModelClass::getModelClass).collect(Collectors.toSet()));
        this.logRestClientClassStructureStorage(builder);
        return builder.build();
    }

    private void separateModelClasses(List<MappedRestObjectModelClass> toHttpDataModelClasses, List<MappedRestObjectModelClass> toHttpQueryModelClasses, List<MappedRestObjectModelClass> toHttpBodyModelClasses, List<MappedRestObjectModelClass> toHttpPathModelClasses) {
        for (MappedRestObjectModelClass modelClass : toHttpDataModelClasses) {
            if (modelClass.getReaderType() == ReaderType.QUERY_STRING) {
                if (modelClass.getModelClass().isParamEntriesPresent() || modelClass.getModelClass().isHeadersPresent()) {
                    toHttpQueryModelClasses.add(modelClass);
                }
            } else if (modelClass.getReaderType() == ReaderType.HTTP_BODY) {
                if (modelClass.getModelClass().isHeadersPresent()) {
                    toHttpQueryModelClasses.add(modelClass.cloneUsingNewModelClass((RestObjectModelClass)((RestClientObjectModelClass)modelClass.getModelClass()).cloneWithHeadersOnly()));
                }
                if (modelClass.getModelClass().isParamEntriesPresent()) {
                    toHttpBodyModelClasses.add(modelClass);
                }
            } else if (modelClass.getModelClass().isParamEntriesPresent() || modelClass.getModelClass().isHeadersPresent()) {
                toHttpQueryModelClasses.add(modelClass);
                toHttpBodyModelClasses.add(modelClass);
            }
            if (!modelClass.getModelClass().isPathVariablesPresent()) continue;
            toHttpPathModelClasses.add(modelClass.cloneUsingNewModelClass((RestObjectModelClass)((RestClientObjectModelClass)modelClass.getModelClass()).cloneWithPathVariablesOnly()));
        }
    }

    private void addValidators(EnvironmentContext environmentContext, RestGenerationContext context, RestClientClassStructureStorage.Builder builder) {
        if (((RestClientModuleGeneratorConfig)environmentContext.get(RestClientModuleGeneratorConfig.class)).isGenerateRequestValidators()) {
            builder.addRequestValidators(this.restModelValidatorBuilder.build(context.getToHttpDataModelClasses().stream().map(MappedRestObjectModelClass::getModelClass).filter(m -> this.isAnnotationPerPackageHierarchyAbsent(m.getModelTypeElement(), DisableValidation.class)).collect(Collectors.toList())));
        }
        if (((RestClientModuleGeneratorConfig)environmentContext.get(RestClientModuleGeneratorConfig.class)).isGenerateResponseValidators()) {
            builder.addResponseValidators(this.restModelValidatorBuilder.build(context.getFromHttpDataModelClasses().stream().map(MappedRestObjectModelClass::getModelClass).filter(m -> this.isAnnotationPerPackageHierarchyAbsent(m.getModelTypeElement(), DisableValidation.class)).collect(Collectors.toList())));
        }
    }

    private void logRestClientClassStructureStorage(RestClientClassStructureStorage.Builder builder) {
        if (this.isDebugEnabled()) {
            this.logClassStructureStorageItem("path variable builder(s)", builder.getPathBuilders());
            this.logClassStructureStorageItem("request model extractor(s)", builder.getRequestModelExtractors());
            this.logClassStructureStorageItem("request model converter(s)", builder.getModelToJsonConverters());
            this.logClassStructureStorageItem("request validator(s)", builder.getRequestValidators());
            this.logClassStructureStorageItem("response model reader", builder.getModelReaders());
            this.logClassStructureStorageItem("response model converter(s)", builder.getModelFromJsonConverters());
            this.logClassStructureStorageItem("response validator(s)", builder.getResponseValidators());
        }
    }
}

