/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.integration.test.internal.impl;

import io.rxmicro.annotation.processor.integration.test.ClasspathResources;
import io.rxmicro.annotation.processor.integration.test.internal.ExampleWithErrorReader;
import io.rxmicro.annotation.processor.integration.test.model.CompilationError;
import io.rxmicro.annotation.processor.integration.test.model.ExampleWithError;
import io.rxmicro.common.InvalidStateException;
import io.rxmicro.common.util.ExCollections;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;

public final class ExampleWithErrorReaderImpl
implements ExampleWithErrorReader {
    private static final String ERROR_LINE_NUMBER_PREFIX = "// Line:";
    private static final String ERROR_MESSAGE_PREFIX = "// Error:";
    private static final CompilationError COMMON_COMPILATION_ERROR = new CompilationError("Annotations processing completed with errors.");

    @Override
    public ExampleWithError read(String classpathResource) {
        String name = this.getName(classpathResource);
        String content = ClasspathResources.getResourceContent(classpathResource);
        List<String> lines = Arrays.asList(content.split(System.lineSeparator()));
        List<CompilationError> compilationErrors = this.getEditableCompilationErrors(classpathResource, lines);
        compilationErrors.add(COMMON_COMPILATION_ERROR);
        return new ExampleWithError(name, content, ExCollections.unmodifiableList(compilationErrors));
    }

    private String getName(String classpathResource) {
        String name = classpathResource.replace('/', '.');
        if (name.endsWith(".java")) {
            name = name.substring(0, name.length() - 5);
        }
        return name;
    }

    private List<CompilationError> getEditableCompilationErrors(String classpathResource, List<String> lines) {
        ArrayList<CompilationError> compilationErrors = new ArrayList<CompilationError>();
        ListIterator<String> iterator = lines.listIterator();
        int lineNumber = -1;
        String message = null;
        while (iterator.hasNext()) {
            String line = iterator.next();
            if (line.startsWith(ERROR_LINE_NUMBER_PREFIX)) {
                this.validateLineNumber(classpathResource, lineNumber);
                lineNumber = this.getErrorLineNumber(classpathResource, line);
            } else if (line.startsWith(ERROR_MESSAGE_PREFIX)) {
                this.validateMessage(classpathResource, message);
                message = this.getErrorMessage(classpathResource, line, iterator);
            }
            if (lineNumber == -1 || message == null) continue;
            compilationErrors.add(new CompilationError(lineNumber, message));
            lineNumber = -1;
            message = null;
        }
        if (compilationErrors.isEmpty()) {
            throw new InvalidStateException("'?' classpath resource does not contain required error line number and error message comment. Example of missing comments are: '? 12' and '? Invalid data'", new Object[]{classpathResource, ERROR_LINE_NUMBER_PREFIX, ERROR_MESSAGE_PREFIX});
        }
        return compilationErrors;
    }

    private void validateLineNumber(String classpathResource, int lineNumber) {
        if (lineNumber != -1) {
            throw new InvalidStateException("'?' classpath resource does not contain required error message comment for found error line number: '? ?'! Example of missing comment is: '? Invalid data'", new Object[]{classpathResource, ERROR_LINE_NUMBER_PREFIX, lineNumber, ERROR_MESSAGE_PREFIX});
        }
    }

    private void validateMessage(String classpathResource, String message) {
        if (message != null) {
            throw new InvalidStateException("'?' classpath resource does not contain required error line number comment for found error message: '? ?'. Example of missing comment is: '? 12'", new Object[]{classpathResource, ERROR_MESSAGE_PREFIX, message, ERROR_LINE_NUMBER_PREFIX});
        }
    }

    private int getErrorLineNumber(String classpathResource, String line) {
        try {
            return Integer.parseInt(line.substring(ERROR_LINE_NUMBER_PREFIX.length()).trim());
        }
        catch (NumberFormatException ex) {
            throw new InvalidStateException("'?' classpath resource contains invalid error line number comment: '?': ?", new Object[]{classpathResource, line, ex.getMessage()});
        }
    }

    private String getErrorMessage(String classpathResource, String line, ListIterator<String> iterator) {
        String message;
        StringBuilder errorMessageBuilder = new StringBuilder().append(line.substring(ERROR_MESSAGE_PREFIX.length()).trim());
        while (iterator.hasNext()) {
            String nextLine = iterator.next();
            if (nextLine.startsWith(ERROR_LINE_NUMBER_PREFIX)) {
                iterator.previous();
                break;
            }
            if (!nextLine.startsWith("//")) break;
            errorMessageBuilder.append(' ').append(nextLine.substring(2).trim());
        }
        if ((message = errorMessageBuilder.toString().trim()).isEmpty()) {
            throw new InvalidStateException("'?' classpath resource contains invalid error message comment: Expected NOT EMPTY message after '?' prefix. Example of missing comment is: '? Invalid data'", new Object[]{classpathResource, ERROR_MESSAGE_PREFIX, ERROR_MESSAGE_PREFIX});
        }
        return message;
    }
}

