/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.integration.test.internal;

import io.rxmicro.common.util.Requires;

public final class SourceCodeResource {
    private static final String SOURCE_OUTPUT = "SOURCE_OUTPUT";
    private final String originalClasspathResource;
    private final String generatedClassNameSourceCodeFile;
    private final String fullClassName;
    private final String simpleClassName;

    public SourceCodeResource(String outputFolder, String originalClasspathResource) {
        this.originalClasspathResource = (String)Requires.require((Object)originalClasspathResource);
        this.fullClassName = this.buildFullClassName(outputFolder, originalClasspathResource);
        this.generatedClassNameSourceCodeFile = this.buildFullNameResource(this.fullClassName);
        this.simpleClassName = this.buildSimpleClassName(this.fullClassName);
    }

    private String buildFullClassName(String outputFolder, String resource) {
        String temp = resource.endsWith(".java") ? (resource.startsWith(outputFolder) ? resource.substring(outputFolder.length(), resource.length() - 5) : resource.substring(0, resource.length() - 5)) : (resource.startsWith(outputFolder) ? resource.substring(outputFolder.length()) : resource);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < temp.length(); ++i) {
            char ch = temp.charAt(i);
            if (ch == '/') {
                if (stringBuilder.length() <= 0) continue;
                stringBuilder.append('.');
                continue;
            }
            stringBuilder.append(ch);
        }
        return stringBuilder.toString();
    }

    private String buildFullNameResource(String fullClassName) {
        StringBuilder stringBuilder = new StringBuilder().append('/').append(SOURCE_OUTPUT).append('/');
        for (int i = 0; i < fullClassName.length(); ++i) {
            char ch = fullClassName.charAt(i);
            if (ch == '.') {
                stringBuilder.append('/');
                continue;
            }
            stringBuilder.append(ch);
        }
        return stringBuilder.append(".java").toString();
    }

    private String buildSimpleClassName(String fullClassName) {
        int last = fullClassName.lastIndexOf(46);
        return last == -1 ? fullClassName : fullClassName.substring(last + 1);
    }

    public String getOriginalClasspathResource() {
        return this.originalClasspathResource;
    }

    public String getGeneratedClassNameSourceCodeFile() {
        return this.generatedClassNameSourceCodeFile;
    }

    public String getFullClassName() {
        return this.fullClassName;
    }

    public String getSimpleClassName() {
        return this.simpleClassName;
    }
}

