/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.integration.test.internal;

import io.rxmicro.common.util.Requires;
import io.rxmicro.resource.model.ResourceException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.function.Supplier;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public final class MavenUtils {
    private static final Properties PROPERTIES_FROM_MAVEN_POM = MavenUtils.getPropertiesFromMavenPOM();

    private static Properties getPropertiesFromMavenPOM() {
        Properties properties;
        block16: {
            MavenXpp3Reader reader = new MavenXpp3Reader();
            String currentDir = System.getProperty("user.dir");
            BufferedReader currentPomReader = Files.newBufferedReader(Paths.get(currentDir + "/pom.xml", new String[0]), StandardCharsets.UTF_8);
            try {
                Model model = reader.read((Reader)currentPomReader);
                if (model.getParent() != null) {
                    String parentFileName = currentDir + "/" + model.getParent().getRelativePath();
                    try (BufferedReader parentPomReader = Files.newBufferedReader(Paths.get(parentFileName, new String[0]), StandardCharsets.UTF_8);){
                        model = reader.read((Reader)parentPomReader);
                    }
                }
                properties = model.getProperties();
                if (currentPomReader == null) break block16;
            }
            catch (Throwable throwable) {
                try {
                    if (currentPomReader != null) {
                        try {
                            ((Reader)currentPomReader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | XmlPullParserException ex) {
                    throw new ResourceException(ex, "Can't read properties from `pom.xml`: ?", new Object[]{ex.getMessage()});
                }
            }
            ((Reader)currentPomReader).close();
        }
        return properties;
    }

    public static String getMavenProperty(String name) {
        String value = (String)Requires.require((Object)PROPERTIES_FROM_MAVEN_POM.getProperty(name), (String)("Property '" + name + "' not defined"), (Supplier[])new Supplier[0]);
        return MavenUtils.isVariable(value) ? MavenUtils.getMavenProperty(MavenUtils.getVariableName(value)) : value;
    }

    private static boolean isVariable(String name) {
        return name.length() > 3 && name.charAt(0) == '$' && name.charAt(1) == '{' && name.charAt(name.length() - 1) == '}';
    }

    private static String getVariableName(String variableExpression) {
        return variableExpression.substring(2, variableExpression.length() - 1);
    }

    private MavenUtils() {
    }
}

