/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.integration.test.internal;

import com.google.common.io.ByteSource;
import com.google.common.io.Resources;
import com.google.testing.compile.JavaFileObjects;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;

public final class JavaSources {
    public static JavaFileObject forResource(String resourceName) {
        if (resourceName.endsWith("moduleinfo.java")) {
            return new ModuleInfoSimpleJavaFileObject(Resources.getResource((String)resourceName));
        }
        return JavaFileObjects.forResource((String)resourceName);
    }

    private JavaSources() {
    }

    private static final class ModuleInfoSimpleJavaFileObject
    extends SimpleJavaFileObject {
        private final ByteSource resourceByteSource;

        private ModuleInfoSimpleJavaFileObject(URL resourceUrl) {
            super(URI.create(resourceUrl.toString().replace("moduleinfo.java", "module-info.java")), JavaFileObject.Kind.SOURCE);
            this.resourceByteSource = Resources.asByteSource((URL)resourceUrl);
        }

        @Override
        public InputStream openInputStream() throws IOException {
            return this.resourceByteSource.openStream();
        }

        @Override
        public Reader openReader(boolean ignoreEncodingErrors) throws IOException {
            return this.resourceByteSource.asCharSource(Charset.defaultCharset()).openStream();
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
            return this.resourceByteSource.asCharSource(Charset.defaultCharset()).read();
        }
    }
}

