/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.integration.test.internal;

import com.google.testing.compile.Compilation;
import com.google.testing.compile.CompilationSubject;
import com.google.testing.compile.Compiler;
import com.google.testing.compile.JavaFileObjectSubject;
import com.google.testing.compile.JavaFileObjects;
import io.rxmicro.annotation.processor.config.LogLevel;
import io.rxmicro.annotation.processor.integration.test.internal.ExampleWithErrorReader;
import io.rxmicro.annotation.processor.integration.test.internal.JavaSources;
import io.rxmicro.annotation.processor.integration.test.internal.SourceCodeResource;
import io.rxmicro.annotation.processor.integration.test.internal.impl.ExampleWithErrorReaderImpl;
import io.rxmicro.annotation.processor.integration.test.model.ExampleWithError;
import io.rxmicro.common.CheckedWrapperException;
import io.rxmicro.common.util.ExCollectors;
import io.rxmicro.common.util.Formats;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.Processor;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import org.junit.jupiter.api.Assertions;
import org.opentest4j.AssertionFailedError;

public abstract class AbstractAnnotationProcessorIntegrationTest {
    private static Field javaFileObjectSubjectActualField;
    final Map<String, String> compilerOptions = new LinkedHashMap<String, String>(Map.of("RX_MICRO_LOG_LEVEL", LogLevel.OFF.name()));
    private final ExampleWithErrorReader exampleWithErrorReader = new ExampleWithErrorReaderImpl();
    private final Set<String> modulePath;
    private final Map<String, String> overriddenSourceOutput = new HashMap<String, String>();

    protected AbstractAnnotationProcessorIntegrationTest(Set<String> modulePath) {
        this.modulePath = modulePath;
    }

    protected void addToModulePath(String path) {
        this.modulePath.add(path);
    }

    protected void removeFromModulePath(String pathFragment) {
        this.modulePath.removeIf(path -> path.contains(pathFragment));
    }

    protected void addCompilerOption(String name, String value) {
        this.compilerOptions.put(name, value);
    }

    protected void registerOverriddenSourceOutput(String sourceCode, String content) {
        this.overriddenSourceOutput.put(sourceCode, content);
    }

    protected abstract Processor createAnnotationProcessor();

    protected Compilation compile(Collection<String> files) {
        return this.compile((JavaFileObject[])files.stream().map(JavaSources::forResource).toArray(JavaFileObject[]::new));
    }

    protected Compilation compile(JavaFileObject ... files) {
        Stream<String> pathStream = Arrays.stream(files).anyMatch(jfo -> jfo.getName().endsWith("module-info.java")) ? Stream.of("--module-path", String.join((CharSequence)File.pathSeparator, this.modulePath)) : Stream.of("-classpath", String.join((CharSequence)File.pathSeparator, this.modulePath));
        return Compiler.javac().withOptions((Iterable)Stream.of(this.compilerOptions.entrySet().stream().map(e -> Formats.format((String)"-A?=?", (Object[])new Object[]{e.getKey(), e.getValue()})), pathStream).flatMap(Function.identity()).collect(Collectors.toList())).withProcessors(new Processor[]{this.createAnnotationProcessor()}).compile(files);
    }

    protected void assertGenerated(Compilation compilation, SourceCodeResource ... expectedSourceCodeResources) throws IOException {
        this.assertGenerated(compilation, false, expectedSourceCodeResources);
    }

    protected void assertGenerated(Compilation compilation, boolean useEqualsToInsteadOfEquivalentSource, SourceCodeResource ... expectedSourceCodeResources) throws IOException {
        Set expectedGeneratedSourceFiles = (Set)Arrays.stream(expectedSourceCodeResources).map(SourceCodeResource::getGeneratedClassNameSourceCodeFile).collect(ExCollectors.toTreeSet());
        Set actualGeneratedSourceFiles = (Set)compilation.generatedSourceFiles().stream().map(FileObject::getName).collect(ExCollectors.toTreeSet());
        Assertions.assertEquals((Object)expectedGeneratedSourceFiles.stream().collect(Collectors.joining(System.lineSeparator())), (Object)actualGeneratedSourceFiles.stream().collect(Collectors.joining(System.lineSeparator())));
        for (SourceCodeResource expectedSourceCodeResource : expectedSourceCodeResources) {
            this.assertGeneratedFile(compilation, expectedSourceCodeResource, useEqualsToInsteadOfEquivalentSource);
        }
    }

    protected ExampleWithError getExampleWithError(String classpathResource) {
        return this.exampleWithErrorReader.read(classpathResource);
    }

    private void assertGeneratedFile(Compilation compilation, SourceCodeResource expectedSourceCodeResource, boolean useEqualsToInsteadOfEquivalentSource) throws IOException {
        JavaFileObject expectedJavaFileObject = this.overriddenSourceOutput.containsKey(expectedSourceCodeResource.getFullClassName()) ? JavaFileObjects.forSourceString((String)(expectedSourceCodeResource.getFullClassName() + ".java"), (String)this.overriddenSourceOutput.get(expectedSourceCodeResource.getFullClassName())) : JavaSources.forResource(expectedSourceCodeResource.getOriginalClasspathResource());
        JavaFileObjectSubject javaFileObjectSubject = CompilationSubject.assertThat((Compilation)compilation).generatedSourceFile(expectedSourceCodeResource.getFullClassName());
        try {
            if (useEqualsToInsteadOfEquivalentSource) {
                javaFileObjectSubject.isEqualTo((Object)expectedJavaFileObject);
            } else {
                javaFileObjectSubject.hasSourceEquivalentTo(expectedJavaFileObject);
            }
        }
        catch (AssertionError error) {
            throw new AssertionFailedError(((Throwable)((Object)error)).getMessage(), (Object)expectedJavaFileObject.getCharContent(false), (Object)this.getActual(javaFileObjectSubject).getCharContent(false));
        }
    }

    private JavaFileObject getActual(JavaFileObjectSubject javaFileObjectSubject) {
        try {
            if (javaFileObjectSubjectActualField == null && !(javaFileObjectSubjectActualField = JavaFileObjectSubject.class.getDeclaredField("actual")).canAccess(javaFileObjectSubject)) {
                javaFileObjectSubjectActualField.setAccessible(true);
            }
            return (JavaFileObject)javaFileObjectSubjectActualField.get(javaFileObjectSubject);
        }
        catch (IllegalAccessException | NoSuchFieldException ex) {
            throw new CheckedWrapperException((Throwable)ex);
        }
    }
}

