/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.integration.test;

import io.rxmicro.common.util.Formats;
import io.rxmicro.common.util.UrlPaths;
import io.rxmicro.resource.model.ResourceException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.function.Supplier;

public final class ClasspathResources {
    public static Set<String> getResourcesAtTheFolderWithAllNestedOnes(String folder, Predicate<String> resourcePredicate) {
        HashSet<String> resources = new HashSet<String>();
        ClasspathResources.readAll(resources, folder, resourcePredicate);
        return Collections.unmodifiableSet(resources);
    }

    public static Set<String> getOnlyChildrenAtTheFolder(String folder, Predicate<String> resourcePredicate) {
        TreeSet<String> resources = new TreeSet<String>();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(ClasspathResources.getResource(folder).openStream(), StandardCharsets.UTF_8));){
            String line;
            while ((line = br.readLine()) != null) {
                if (!resourcePredicate.test(line)) continue;
                resources.add(line);
            }
        }
        catch (IOException ex) {
            throw new ResourceException((Throwable)ex, "Can't load resources from folder: ?", new Object[]{folder});
        }
        return Collections.unmodifiableSet(resources);
    }

    public static String getResourceContent(String resource) {
        String string;
        block8: {
            InputStream in = ClasspathResources.getResource(resource).openStream();
            try {
                string = new Scanner(in, StandardCharsets.UTF_8).useDelimiter("\\A").next();
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new ResourceException((Throwable)ex, "Can't read resource: ?", new Object[]{resource});
                }
            }
            in.close();
        }
        return string;
    }

    private static void readAll(Set<String> resources, String folder, Predicate<String> resourcePredicate) {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(ClasspathResources.getResource(folder).openStream(), StandardCharsets.UTF_8));){
            String line;
            while ((line = br.readLine()) != null) {
                String resource = ClasspathResources.normalize(folder + "/" + line);
                if (line.indexOf(46) == -1) {
                    ClasspathResources.readAll(resources, resource, resourcePredicate);
                    continue;
                }
                if (!resourcePredicate.test(resource)) continue;
                resources.add(resource);
            }
        }
        catch (IOException ex) {
            throw new ResourceException((Throwable)ex, "Can't read resources from folder: ?", new Object[]{folder});
        }
    }

    private static URL getResource(String resource) {
        List<Supplier<URL>> resourceSuppliers = List.of(() -> Thread.currentThread().getContextClassLoader().getResource(resource), () -> ClasspathResources.class.getClassLoader().getResource(resource), () -> ClasspathResources.class.getResource(resource));
        for (Supplier<URL> supplier : resourceSuppliers) {
            URL url = supplier.get();
            if (url == null) continue;
            return url;
        }
        throw new IllegalArgumentException(Formats.format((String)"Classpath resource not found: '?'", (Object[])new Object[]{resource}));
    }

    private static String normalize(String path) {
        return UrlPaths.normalizeUrlPath((String)path).substring(1);
    }

    private ClasspathResources() {
    }
}

