/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.integration.test;

import com.google.testing.compile.Compilation;
import com.google.testing.compile.CompilationSubject;
import com.google.testing.compile.JavaFileObjects;
import io.rxmicro.annotation.processor.integration.test.ClasspathResources;
import io.rxmicro.annotation.processor.integration.test.ExternalModule;
import io.rxmicro.annotation.processor.integration.test.config.ExcludeExample;
import io.rxmicro.annotation.processor.integration.test.config.IncludeExample;
import io.rxmicro.annotation.processor.integration.test.internal.AbstractAnnotationProcessorIntegrationTest;
import io.rxmicro.annotation.processor.integration.test.internal.SourceCodeResource;
import io.rxmicro.annotation.processor.integration.test.model.CompilationError;
import io.rxmicro.annotation.processor.integration.test.model.ExampleWithError;
import io.rxmicro.common.InvalidStateException;
import io.rxmicro.common.RxMicroModule;
import io.rxmicro.common.util.Formats;
import io.rxmicro.common.util.Requires;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.tools.JavaFileObject;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;

public abstract class AbstractRxMicroAnnotationProcessorIntegrationTest
extends AbstractAnnotationProcessorIntegrationTest {
    private static final String ERROR = "error";
    private static final String INPUT = "input";
    private static final String OUTPUT = "output";
    private final Map<String, String> aggregators;
    private final Set<ExternalModule> externalModules = new HashSet<ExternalModule>();

    public static String getInputAbsolutePath(Class<?> clazz) {
        return AbstractRxMicroAnnotationProcessorIntegrationTest.getAbsolutePath(clazz, INPUT);
    }

    public static String getOutputAbsolutePath(Class<?> clazz) {
        return AbstractRxMicroAnnotationProcessorIntegrationTest.getAbsolutePath(clazz, OUTPUT);
    }

    private static String getAbsolutePath(Class<?> clazz, String resource) {
        try {
            return new File(((URL)Requires.require((Object)clazz.getClassLoader().getResource(resource))).toURI()).getAbsolutePath();
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException("Classpath resource not found: " + ex.getMessage(), ex);
        }
    }

    public AbstractRxMicroAnnotationProcessorIntegrationTest(String ... aggregatorSimpleClassName) {
        super(Arrays.stream((String[])Requires.require((Object)new File("..").list())).filter(module -> module.startsWith("rxmicro")).map(module -> "../" + module + "/target/classes").collect(Collectors.toSet()));
        this.aggregators = Stream.concat(Arrays.stream(aggregatorSimpleClassName), Stream.of("$$Reflections")).collect(Collectors.toMap(Function.identity(), cl -> Formats.format((String)"?.?", (Object[])new Object[]{"rxmicro", cl})));
    }

    protected final void addAggregator(String name) {
        this.aggregators.put(name, Formats.format((String)"?.?", (Object[])new Object[]{"rxmicro", name}));
    }

    protected JavaFileObject moduleInfo(Collection<RxMicroModule> rxMicroModules, Collection<ExternalModule> externalModules) {
        return JavaFileObjects.forSourceLines((String)"module-info", (Iterable)Stream.of(Stream.of("module rxmicro.dynamic.integration.test {"), rxMicroModules.stream().map(m -> Formats.format((String)"    requires ?;", (Object[])new Object[]{m.getName()})), externalModules.stream().map(m -> Formats.format((String)"    requires ?;", (Object[])new Object[]{m.getModuleName()})), Stream.of("}")).flatMap(Function.identity()).collect(Collectors.toList()));
    }

    protected JavaFileObject moduleInfo(RxMicroModule ... rxMicroModules) {
        return this.moduleInfo(Arrays.asList(rxMicroModules), this.externalModules);
    }

    protected void addExternalModule(ExternalModule externalModule) {
        this.externalModules.add(externalModule);
        this.addToModulePath(externalModule.getJarPath());
    }

    protected final void shouldCompileAndGenerateClassesSuccessfully(String packageName) throws IOException {
        Compilation compilation = this.compileAllIn(packageName);
        CompilationSubject.assertThat((Compilation)compilation).succeeded();
        this.assertAllGeneratedIn(compilation, packageName);
    }

    protected final void shouldThrowCompilationError(String classpathResource, RxMicroModule ... rxMicroModules) {
        ExampleWithError exampleWithError = this.getExampleWithError(classpathResource);
        JavaFileObject restController = JavaFileObjects.forSourceLines((String)exampleWithError.getName(), (String[])new String[]{exampleWithError.getSource()});
        Compilation compilation = this.compile(restController, this.moduleInfo(rxMicroModules));
        for (CompilationError compilationError : exampleWithError.getCompilationErrors()) {
            if (compilationError.isLineNumberPresents()) {
                CompilationSubject.assertThat((Compilation)compilation).hadErrorContaining(compilationError.getMessage()).inFile(restController).onLine((long)compilationError.getLineNumber());
                continue;
            }
            CompilationSubject.assertThat((Compilation)compilation).hadErrorContaining(compilationError.getMessage());
        }
        CompilationSubject.assertThat((Compilation)compilation).hadErrorCount(exampleWithError.getCompilationErrors().size());
    }

    protected Compilation compileAllIn(String packageName) {
        return this.compile(ClasspathResources.getResourcesAtTheFolderWithAllNestedOnes("input/" + packageName, r -> r.endsWith(".java")));
    }

    protected SourceCodeResource sourceCodeResource(String resource) {
        if (resource.startsWith(OUTPUT)) {
            return new SourceCodeResource(OUTPUT, resource);
        }
        return new SourceCodeResource(OUTPUT, "output/" + resource);
    }

    protected boolean withEnvironmentCustomizer() {
        return true;
    }

    private void assertAllGeneratedIn(Compilation compilation, String packageName) throws IOException {
        Set<SourceCodeResource> resources = ClasspathResources.getResourcesAtTheFolderWithAllNestedOnes("output/" + packageName, r -> r.endsWith(".java")).stream().map(this::sourceCodeResource).collect(Collectors.toSet());
        this.registerAllOverriddenSourceOutputs(resources);
        if (this.withEnvironmentCustomizer()) {
            resources.add(this.sourceCodeResource(Formats.format((String)"?/?/$$EnvironmentCustomizer.java", (Object[])new Object[]{OUTPUT, "rxmicro"})));
        }
        this.assertGenerated(compilation, resources.toArray(new SourceCodeResource[0]));
    }

    private void registerAllOverriddenSourceOutputs(Set<SourceCodeResource> resources) {
        Iterator<SourceCodeResource> iterator = resources.iterator();
        HashSet toAdd = new HashSet();
        while (iterator.hasNext()) {
            SourceCodeResource resource = iterator.next();
            Optional.ofNullable(this.aggregators.get(resource.getSimpleClassName())).ifPresent(aggregatorFullClassName -> {
                String aggregatorResource = Formats.format((String)"?/?.java", (Object[])new Object[]{OUTPUT, aggregatorFullClassName.replace(".", "/")});
                this.registerOverriddenSourceOutput((String)aggregatorFullClassName, ClasspathResources.getResourceContent(resource.getOriginalClasspathResource()));
                iterator.remove();
                toAdd.add(this.sourceCodeResource(aggregatorResource));
            });
        }
        resources.addAll(toAdd);
    }

    private static void validateIncludesAndExcludes(Method method, List<IncludeExample> includeExamples, List<ExcludeExample> excludeExamples) {
        if (!includeExamples.isEmpty() && !excludeExamples.isEmpty()) {
            throw new InvalidStateException("Only includes OR excludes must be specified per test method: ?", new Object[]{method});
        }
    }

    private static Predicate<String> createPackagePredicate(List<IncludeExample> includeExamples, List<ExcludeExample> excludeExamples) {
        if (!includeExamples.isEmpty()) {
            List patterns = includeExamples.stream().map(annotation -> Pattern.compile(annotation.value())).collect(Collectors.toList());
            return resource -> patterns.stream().anyMatch(pattern -> pattern.matcher(resource.replace('/', '.')).find());
        }
        if (!excludeExamples.isEmpty()) {
            List patterns = excludeExamples.stream().map(annotation -> Pattern.compile(annotation.value())).collect(Collectors.toList());
            return resource -> patterns.stream().noneMatch(pattern -> pattern.matcher(resource.replace('/', '.')).find());
        }
        return resource -> true;
    }

    protected static final class AllErrorPackagesArgumentsProvider
    implements ArgumentsProvider {
        protected AllErrorPackagesArgumentsProvider() {
        }

        public Stream<? extends Arguments> provideArguments(ExtensionContext extensionContext) {
            List<IncludeExample> includeExamples = List.of((IncludeExample[])extensionContext.getRequiredTestMethod().getAnnotationsByType(IncludeExample.class));
            List<ExcludeExample> excludeExamples = List.of((ExcludeExample[])extensionContext.getRequiredTestMethod().getAnnotationsByType(ExcludeExample.class));
            AbstractRxMicroAnnotationProcessorIntegrationTest.validateIncludesAndExcludes(extensionContext.getRequiredTestMethod(), includeExamples, excludeExamples);
            return ClasspathResources.getResourcesAtTheFolderWithAllNestedOnes(AbstractRxMicroAnnotationProcessorIntegrationTest.ERROR, r -> !r.endsWith(".class")).stream().filter(AbstractRxMicroAnnotationProcessorIntegrationTest.createPackagePredicate(includeExamples, excludeExamples)).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
        }
    }

    protected static final class AllInputPackagesArgumentsProvider
    implements ArgumentsProvider {
        protected AllInputPackagesArgumentsProvider() {
        }

        public Stream<? extends Arguments> provideArguments(ExtensionContext extensionContext) {
            List<IncludeExample> includeExamples = List.of((IncludeExample[])extensionContext.getRequiredTestMethod().getAnnotationsByType(IncludeExample.class));
            List<ExcludeExample> excludeExamples = List.of((ExcludeExample[])extensionContext.getRequiredTestMethod().getAnnotationsByType(ExcludeExample.class));
            AbstractRxMicroAnnotationProcessorIntegrationTest.validateIncludesAndExcludes(extensionContext.getRequiredTestMethod(), includeExamples, excludeExamples);
            return ClasspathResources.getOnlyChildrenAtTheFolder(AbstractRxMicroAnnotationProcessorIntegrationTest.INPUT, r -> r.startsWith("io.rxmicro.examples")).stream().filter(AbstractRxMicroAnnotationProcessorIntegrationTest.createPackagePredicate(includeExamples, excludeExamples)).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
        }
    }
}

