/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.documentation.asciidoctor.model;

import io.rxmicro.annotation.processor.common.model.DocumentStructure;
import io.rxmicro.annotation.processor.config.DocumentationType;
import io.rxmicro.annotation.processor.documentation.asciidoctor.model.ResourceGroup;
import io.rxmicro.annotation.processor.documentation.model.ProjectMetaData;
import io.rxmicro.common.util.Formats;
import io.rxmicro.common.util.Requires;
import io.rxmicro.documentation.DocumentationDefinition;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.lang.model.element.ModuleElement;

public final class RestControllerBasicsDocumentStructure
extends DocumentStructure {
    private final ProjectMetaData projectMetaData;
    private final DocumentationDefinition documentationDefinition;
    private final ModuleElement currentModule;
    private final ResourceGroup resourceGroup;

    public RestControllerBasicsDocumentStructure(ProjectMetaData projectMetaData, DocumentationDefinition documentationDefinition, ModuleElement currentModule, ResourceGroup resourceGroup) {
        this.projectMetaData = projectMetaData;
        this.documentationDefinition = documentationDefinition;
        this.currentModule = (ModuleElement)Requires.require((Object)currentModule);
        this.resourceGroup = (ResourceGroup)Requires.require((Object)resourceGroup);
    }

    public ModuleElement getCurrentModule() {
        return this.currentModule;
    }

    public DocumentationType getDocumentationType() {
        return DocumentationType.ASCII_DOCTOR;
    }

    public String getProjectDirectory() {
        return this.projectMetaData.getProjectDirectory();
    }

    public Optional<String> getCustomDestinationDirectory() {
        String destinationDirectory = this.documentationDefinition.destinationDirectory();
        return destinationDirectory.isEmpty() ? Optional.empty() : Optional.of(destinationDirectory);
    }

    public String getName() {
        return Formats.format((String)"?-Basics-fragment.adoc", (Object[])new Object[]{this.resourceGroup.getRestControllerClass()});
    }

    public String getTemplateName() {
        return "documentation/asciidoctor/micro-service-basics-document-template.adocftl";
    }

    public Map<String, Object> getTemplateVariables() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("GROUP", this.resourceGroup);
        return map;
    }
}

