/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.documentation.asciidoctor.model;

import io.rxmicro.annotation.processor.documentation.asciidoctor.model.DocumentedModelField;
import io.rxmicro.common.util.Requires;
import java.util.List;
import java.util.Map;

public final class Response
implements Comparable<Response> {
    private final int code;
    private final String description;
    private final List<DocumentedModelField> headers;
    private final List<Map.Entry<String, List<DocumentedModelField>>> parameters;
    private final String example;
    private final String schema;

    private Response(int code, String description, List<DocumentedModelField> headers, List<Map.Entry<String, List<DocumentedModelField>>> parameters, String example, String schema) {
        this.code = code;
        this.description = description;
        this.headers = headers;
        this.parameters = parameters;
        this.example = example;
        this.schema = schema;
    }

    public int getCode() {
        return this.code;
    }

    public boolean isDescriptionPresent() {
        return this.description != null;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isExamplePresent() {
        return this.example != null;
    }

    public String getExample() {
        return this.example;
    }

    public boolean isSchemaPresent() {
        return this.schema != null;
    }

    public String getSchema() {
        return this.schema;
    }

    public List<DocumentedModelField> getHeaders() {
        return this.headers;
    }

    public List<Map.Entry<String, List<DocumentedModelField>>> getParameters() {
        return this.parameters;
    }

    public int hashCode() {
        return this.code;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Response response = (Response)other;
        return this.code == response.code;
    }

    @Override
    public int compareTo(Response other) {
        return Integer.compare(this.code, other.code);
    }

    public static final class Builder {
        private static final int DEFAULT_STATUS_CODE = 200;
        private int code = 200;
        private String description;
        private List<DocumentedModelField> headers = List.of();
        private List<Map.Entry<String, List<DocumentedModelField>>> parameters = List.of();
        private String example;
        private String schema;

        public Builder setCode(int code) {
            this.code = code;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = (String)Requires.require((Object)description);
            return this;
        }

        public Builder setHeaders(List<DocumentedModelField> headers) {
            this.headers = (List)Requires.require(headers);
            return this;
        }

        public Builder setParameters(List<Map.Entry<String, List<DocumentedModelField>>> parameters) {
            this.parameters = (List)Requires.require(parameters);
            return this;
        }

        public Builder setExample(String example) {
            this.example = (String)Requires.require((Object)example);
            return this;
        }

        public Builder setSchema(String schema) {
            this.schema = (String)Requires.require((Object)schema);
            return this;
        }

        public Response build() {
            return new Response(this.code, this.description, this.headers, this.parameters, this.example, this.schema);
        }
    }
}

